/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class ChannelOutputStream
extends OutputStream {
    private final ByteBuffer single = ByteBuffer.allocate(1);
    @Nullable
    protected WritableByteChannel channel;

    protected ChannelOutputStream() {
    }

    public ChannelOutputStream(@WillCloseWhenClosed WritableByteChannel channel2) {
        this.channel = Objects.requireNonNull(channel2);
    }

    @Override
    public void write(int b) throws IOException {
        this.write((ByteBuffer)this.single.put(0, (byte)b).rewind());
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    private void write(ByteBuffer bb) throws IOException {
        while (bb.hasRemaining()) {
            if (0 != this.channel.write(bb)) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.channel.close();
    }
}

