/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.win32;

import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.FromNativeContext;
import com.sun.jna.StringArray;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;

public class W32APITypeMapper
extends DefaultTypeMapper {
    public static final TypeMapper UNICODE = new W32APITypeMapper(true);
    public static final TypeMapper ASCII = new W32APITypeMapper(false);

    protected W32APITypeMapper(boolean unicode) {
        if (unicode) {
            TypeConverter stringConverter = new TypeConverter(){

                @Override
                public Object toNative(Object value2, ToNativeContext context) {
                    if (value2 == null) {
                        return null;
                    }
                    if (value2 instanceof String[]) {
                        return new StringArray((String[])value2, true);
                    }
                    return new WString(value2.toString());
                }

                @Override
                public Object fromNative(Object value2, FromNativeContext context) {
                    if (value2 == null) {
                        return null;
                    }
                    return value2.toString();
                }

                @Override
                public Class nativeType() {
                    return WString.class;
                }
            };
            this.addTypeConverter(String.class, stringConverter);
            this.addToNativeConverter(String[].class, stringConverter);
        }
        TypeConverter booleanConverter = new TypeConverter(){

            @Override
            public Object toNative(Object value2, ToNativeContext context) {
                return new Integer(Boolean.TRUE.equals(value2) ? 1 : 0);
            }

            @Override
            public Object fromNative(Object value2, FromNativeContext context) {
                return (Integer)value2 != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public Class nativeType() {
                return Integer.class;
            }
        };
        this.addTypeConverter(Boolean.class, booleanConverter);
    }
}

