/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERBMPString
extends ASN1Object
implements DERString {
    String string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBMPString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERBMPString) {
            return DERBMPString.getInstance(dERObject);
        }
        return new DERBMPString(ASN1OctetString.getInstance(dERObject).getOctets());
    }

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[2 * i] << 8 | byArray[2 * i + 1] & 0xFF);
        }
        this.string = new String(cArray);
    }

    public DERBMPString(String string2) {
        this.string = string2;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    protected boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERBMPString)) {
            return false;
        }
        DERBMPString dERBMPString = (DERBMPString)dERObject;
        return this.getString().equals(dERBMPString.getString());
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[2 * i] = (byte)(cArray[i] >> 8);
            byArray[2 * i + 1] = (byte)cArray[i];
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

