/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truevfs.driver.file.FileBufferPool;
import net.java.truevfs.driver.file.FileNode;

@NotThreadSafe
final class FileBuffer
extends FileNode {
    FileBuffer(Path path, FileBufferPool pool) {
        super(path);
        assert (null != pool);
        this.pool = pool;
    }

    @Override
    public void release() throws IOException {
        this.pool(null);
    }

    private void pool(@CheckForNull FileBufferPool newPool) throws IOException {
        FileBufferPool oldPool = this.pool;
        this.pool = newPool;
        if (oldPool != newPool) {
            Files.deleteIfExists(this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.pool(null);
        }
        finally {
            super.finalize();
        }
    }
}

