/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.access.TBIO;
import net.java.truevfs.access.TConfig;
import net.java.truevfs.access.TFile;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;

@Immutable
public final class TFileOutputStream
extends DecoratingOutputStream {
    @CreatesObligation
    public TFileOutputStream(String path) throws IOException {
        this(path, false);
    }

    @CreatesObligation
    public TFileOutputStream(String path, boolean append2) throws IOException {
        this((File)new TFile(path), append2);
    }

    @CreatesObligation
    public TFileOutputStream(String path, FsAccessOption ... options) throws IOException {
        this((File)new TFile(path), options);
    }

    @CreatesObligation
    public TFileOutputStream(File file) throws IOException {
        this(file, false);
    }

    @CreatesObligation
    public TFileOutputStream(File file, boolean append2) throws IOException {
        this(file, FsAccessOptions.NONE.set(FsAccessOption.APPEND, append2));
    }

    @CreatesObligation
    public TFileOutputStream(File file, FsAccessOption ... options) throws IOException {
        this(file, FsAccessOptions.of(options));
    }

    @CreatesObligation
    public TFileOutputStream(File file, BitField<FsAccessOption> options) throws IOException {
        super(TBIO.output(TConfig.current().getAccessPreferences().or(options), file, null).stream(null));
    }
}

