/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERUTCTime
extends ASN1Object {
    String time;

    public static DERUTCTime getInstance(Object object) {
        if (object == null || object instanceof DERUTCTime) {
            return (DERUTCTime)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTCTime getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof DERUTCTime) {
            return DERUTCTime.getInstance(dERObject);
        }
        return new DERUTCTime(((ASN1OctetString)dERObject).getOctets());
    }

    public DERUTCTime(String string2) {
        this.time = string2;
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public DERUTCTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = simpleDateFormat.format(date);
    }

    DERUTCTime(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.time = new String(cArray);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssz");
        return simpleDateFormat.parse(this.getTime());
    }

    public Date getAdjustedDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.getAdjustedTime());
    }

    public String getTime() {
        if (this.time.indexOf(45) < 0 && this.time.indexOf(43) < 0) {
            if (this.time.length() == 11) {
                return this.time.substring(0, 10) + "00GMT+00:00";
            }
            return this.time.substring(0, 12) + "GMT+00:00";
        }
        int n = this.time.indexOf(45);
        if (n < 0) {
            n = this.time.indexOf(43);
        }
        String string2 = this.time;
        if (n == this.time.length() - 3) {
            string2 = string2 + "00";
        }
        if (n == 10) {
            return string2.substring(0, 10) + "00GMT" + string2.substring(10, 13) + ":" + string2.substring(13, 15);
        }
        return string2.substring(0, 12) + "GMT" + string2.substring(12, 15) + ":" + string2.substring(15, 17);
    }

    public String getAdjustedTime() {
        String string2 = this.getTime();
        if (string2.charAt(0) < '5') {
            return "20" + string2;
        }
        return "19" + string2;
    }

    private byte[] getOctets() {
        char[] cArray = this.time.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    @Override
    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(23, this.getOctets());
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTCTime)) {
            return false;
        }
        return this.time.equals(((DERUTCTime)dERObject).time);
    }

    @Override
    public int hashCode() {
        return this.time.hashCode();
    }

    public String toString() {
        return this.time;
    }
}

