/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.driver.zip.raes.crypto;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.LittleEndianOutputStream;
import net.java.truecommons.io.Sink;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.comp.zip.crypto.CipherOutputStream;
import net.java.truevfs.comp.zip.crypto.CtrBlockCipher;
import net.java.truevfs.driver.zip.raes.crypto.RaesOutputStream;
import net.java.truevfs.driver.zip.raes.crypto.Type0RaesParameters;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class Type0RaesOutputStream
extends RaesOutputStream {
    static final int ITERATION_COUNT = 2005;
    private boolean finished;
    private final AesKeyStrength keyStrength;
    private Mac mac;
    private Mac klac;
    private LittleEndianOutputStream leos;
    private long start;

    Type0RaesOutputStream(Type0RaesParameters param2, Sink sink) throws IOException {
        assert (null != param2);
        assert (null != sink);
        AesKeyStrength keyStrength = param2.getKeyStrength();
        int keyStrengthOrdinal = keyStrength.ordinal();
        int keyStrengthBits = keyStrength.getBits();
        int keyStrengthBytes = keyStrength.getBytes();
        this.keyStrength = keyStrength;
        byte[] salt = new byte[keyStrengthBytes];
        new SecureRandom().nextBytes(salt);
        SHA256Digest digest = new SHA256Digest();
        assert (digest.getDigestSize() >= keyStrengthBytes);
        char[] pwdChars = param2.getPasswordForWriting();
        byte[] pwdBytes = PBEParametersGenerator.PKCS12PasswordToBytes(pwdChars);
        Arrays.fill(pwdChars, '\u0000');
        PKCS12ParametersGenerator gen = new PKCS12ParametersGenerator(digest);
        gen.init(pwdBytes, salt, 2005);
        ParametersWithIV aesCtrParam = (ParametersWithIV)((PBEParametersGenerator)gen).generateDerivedParameters(keyStrengthBits, 128);
        CipherParameters sha256HMmacParam = ((PBEParametersGenerator)gen).generateDerivedMacParameters(keyStrengthBits);
        Arrays.fill(pwdBytes, (byte)0);
        BufferedBlockCipher cipher = new BufferedBlockCipher(new CtrBlockCipher(new AESFastEngine()));
        cipher.init(true, aesCtrParam);
        this.mac = new HMac(digest);
        HMac mac = this.mac;
        mac.init(sha256HMmacParam);
        this.klac = new HMac(new SHA256Digest());
        HMac klac = this.klac;
        klac.init(sha256HMmacParam);
        byte[] cipherKey = ((KeyParameter)aesCtrParam.getParameters()).getKey();
        klac.update(cipherKey, 0, cipherKey.length);
        OutputStream out = sink.stream();
        try {
            LittleEndianOutputStream leos = this.leos = new LittleEndianOutputStream(out);
            this.out = new CipherOutputStream(cipher, new MacOutputStream(leos, mac));
            leos.writeInt(1397047634);
            leos.writeByte(0);
            leos.writeByte(keyStrengthOrdinal);
            leos.writeShort(2005);
            leos.write(salt);
            this.start = leos.size();
            assert ((long)(8 + salt.length) == this.start);
        }
        catch (Throwable ex) {
            try {
                out.close();
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    @Override
    public AesKeyStrength getKeyStrength() {
        return this.keyStrength;
    }

    private void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        ((CipherOutputStream)this.out).finish();
        long trailer = this.leos.size();
        Mac mac = this.mac;
        assert (mac.getMacSize() == this.klac.getMacSize());
        byte[] buf = new byte[mac.getMacSize()];
        long length = trailer - this.start;
        Type0RaesOutputStream.klac(this.klac, length, buf);
        this.leos.write(buf, 0, buf.length / 2);
        int bufLength = mac.doFinal(buf, 0);
        assert (bufLength == buf.length);
        this.leos.write(buf, 0, buf.length / 2);
        assert (this.leos.size() - trailer == (long)buf.length);
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }
}

