/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Option<E>
extends AbstractCollection<E>
implements Serializable {
    private static final long serialVersionUID = 0L;

    private Option() {
    }

    public static <T> Option<T> apply(@CheckForNull T element) {
        return null == element ? None.INSTANCE : new Some<T>(element);
    }

    public static <T> Option<T> none() {
        return None.INSTANCE;
    }

    public static <T> Option<T> some(T element) {
        return new Some<T>(Objects.requireNonNull(element));
    }

    public abstract E get() throws NoSuchElementException;

    @Nullable
    public abstract E getOrElse(@CheckForNull E var1);

    @Nullable
    public abstract E orNull();

    public Option<E> orElse(Option<E> alternative) {
        return this.isEmpty() ? alternative : this;
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    private static final class Some<T>
    extends Option<T> {
        final T element;

        Some(T element) {
            assert (null != element);
            this.element = element;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.element).iterator();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public T get() {
            return this.element;
        }

        @Override
        public T getOrElse(T alternative) {
            return this.element;
        }

        @Override
        public T orNull() {
            return this.element;
        }

        @Override
        public boolean equals(Object that) {
            return this == that || that instanceof Some && this.element.equals(((Some)that).element);
        }

        @Override
        public int hashCode() {
            return this.element.hashCode();
        }
    }

    private static final class None<T>
    extends Option<T> {
        static final None<Object> INSTANCE = new None();

        private None() {
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public T getOrElse(T alternative) {
            return alternative;
        }

        @Override
        public T orNull() {
            return null;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof None;
        }

        @Override
        public int hashCode() {
            return 42;
        }
    }
}

