/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.macosx;

import java.util.Map;
import java.util.ServiceConfigurationError;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.annotations.ServiceImplementation;
import net.java.truecommons.key.macosx.OsxKeyManager;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truecommons.key.spec.spi.KeyManagerMapModifier;

@Immutable
@ServiceImplementation
public final class OsxAesPbeKeyManagerMapModifier
extends KeyManagerMapModifier {
    @Override
    public Map<Class<?>, KeyManager<?>> apply(Map<Class<?>, KeyManager<?>> map2) {
        if (!"Mac OS X".equals(System.getProperty("os.name"))) {
            return map2;
        }
        KeyManager<?> m = map2.get(AesPbeParameters.class);
        if (null == m) {
            throw new ServiceConfigurationError("This module is a pure persistence service and depends on another key manager module to implement the user interface.");
        }
        map2.put(AesPbeParameters.class, new OsxKeyManager<AesPbeParameters>(m, AesPbeParameters.class));
        return map2;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

