/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.console;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Console;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.prompting.KeyPromptingDisabledException;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingPbeParameters;

@ThreadSafe
abstract class ConsolePromptingPbeParametersView<P extends PromptingPbeParameters<P, S>, S extends KeyStrength>
implements PromptingKey.View<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(ConsolePromptingPbeParametersView.class.getName());
    private static final Object lock = new Object();
    private static final int MIN_PASSWD_LEN = 8;
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private static URI lastResource = URI.create("");
    private static final String YES = resources.getString("yes");
    private static final String NO = resources.getString("no");

    ConsolePromptingPbeParametersView() {
    }

    protected abstract P newPbeParameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void promptKeyForWriting(PromptingKey.Controller<P> controller2) throws KeyPromptingDisabledException {
        Console con = System.console();
        if (null == con) {
            throw new KeyPromptingDisabledException();
        }
        Object object = lock;
        synchronized (object) {
            URI resource = controller2.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("writeKey.banner"), resource);
            }
            lastResource = resource;
            PromptingPbeParameters param2 = (PromptingPbeParameters)controller2.getKeyClone();
            if (null == param2) {
                param2 = this.newPbeParameters();
            }
            while (true) {
                char[] input1;
                if (null == (input1 = con.readPassword(resources.getString("writeKey.newPasswd1"), new Object[0])) || 0 >= input1.length) {
                    return;
                }
                if (8 > input1.length) {
                    con.printf(resources.getString("writeKey.passwd.tooShort"), 8);
                    continue;
                }
                try {
                    char[] input2;
                    block26: {
                        input2 = con.readPassword(resources.getString("writeKey.newPasswd2"), new Object[0]);
                        if (input2 == null) {
                            return;
                        }
                        try {
                            if (Arrays.equals(input1, input2)) break block26;
                            con.printf(resources.getString("writeKey.passwd.noMatch"), new Object[0]);
                        }
                        catch (Throwable throwable) {
                            Arrays.fill(input2, '\u0000');
                            throw throwable;
                        }
                        Arrays.fill(input2, '\u0000');
                        continue;
                    }
                    param2.setPassword(input1);
                    Arrays.fill(input2, '\u0000');
                }
                finally {
                    Arrays.fill(input1, '\u0000');
                    continue;
                }
                break;
            }
            con.printf(resources.getString("keyStrength.banner"), new Object[0]);
            StringBuilder builder = new StringBuilder();
            KeyStrength[] array = param2.getAllKeyStrengths();
            HashMap<Integer, KeyStrength> map2 = new HashMap<Integer, KeyStrength>(array.length / 3 * 4 + 1);
            PrintWriter writer = con.writer();
            for (KeyStrength strength : array) {
                if (0 < builder.length()) {
                    builder.append('/');
                }
                builder.append(strength.getBits());
                map2.put(strength.getBits(), strength);
                writer.println(strength);
            }
            String selection = builder.toString();
            while (true) {
                Object keyStrength = param2.getKeyStrength();
                String input2 = con.readLine(resources.getString("keyStrength.prompt"), selection, null == keyStrength ? 0 : keyStrength.getBits());
                if (null == input2 || input2.length() <= 0) break;
                try {
                    int bits2 = Integer.parseInt(input2);
                    KeyStrength strength = (KeyStrength)map2.get(bits2);
                    if (null == strength) continue;
                    assert (strength.getBits() == bits2);
                    param2.setKeyStrength(strength);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                break;
            }
            controller2.setKeyClone(param2);
        }
    }

    @Override
    public void promptKeyForReading(PromptingKey.Controller<P> controller2, boolean invalid) throws KeyPromptingDisabledException {
        Console con = System.console();
        if (null == con) {
            throw new KeyPromptingDisabledException();
        }
        Object object = lock;
        synchronized (object) {
            String changeKey;
            if (invalid) {
                con.printf(resources.getString("readKey.invalid"), new Object[0]);
            }
            URI resource = controller2.getResource();
            assert (null != resource);
            if (!lastResource.equals(resource)) {
                con.printf(resources.getString("readKey.banner"), resource);
            }
            lastResource = resource;
            char[] passwd = con.readPassword(resources.getString("readKey.passwd"), new Object[0]);
            if (null == passwd || passwd.length <= 0) {
                controller2.setKeyClone(null);
                return;
            }
            P param2 = this.newPbeParameters();
            param2.setPassword(passwd);
            Arrays.fill(passwd, '\u0000');
            do {
                changeKey = con.readLine(resources.getString("readKey.change"), new Object[0]);
                param2.setChangeRequested(YES.equalsIgnoreCase(changeKey));
            } while (null != changeKey && changeKey.length() > 0 && !YES.equalsIgnoreCase(changeKey) && !NO.equalsIgnoreCase(changeKey));
            controller2.setKeyClone(param2);
            return;
        }
    }
}

