/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.NonWritableChannelException;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.AbstractSeekableChannel;

@NotThreadSafe
public final class ByteBufferChannel
extends AbstractSeekableChannel {
    private ByteBuffer buffer;
    private long position;
    private boolean closed;

    public ByteBufferChannel(ByteBuffer buffer) {
        this.buffer = (ByteBuffer)buffer.duplicate().rewind();
    }

    public ByteBuffer getBuffer() {
        return this.buffer.duplicate();
    }

    @Deprecated
    public ByteBuffer bufferDuplicate() {
        return this.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        int srcLimit;
        this.checkOpen();
        int remaining = dst.remaining();
        if (remaining <= 0) {
            return 0;
        }
        long oldPosition = this.position;
        ByteBuffer buffer = this.buffer;
        if (oldPosition >= (long)buffer.limit()) {
            return -1;
        }
        buffer.position((int)oldPosition);
        int available = buffer.remaining();
        if (available > remaining) {
            srcLimit = buffer.limit();
            buffer.limit(buffer.position() + remaining);
        } else {
            srcLimit = -1;
            remaining = available;
        }
        try {
            dst.put(buffer);
        }
        finally {
            if (0 <= srcLimit) {
                buffer.limit(srcLimit);
            }
        }
        assert ((long)buffer.position() == oldPosition + (long)remaining);
        this.position += (long)remaining;
        return remaining;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        if (this.position > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        int oldPosition = (int)this.position;
        int remaining = src.remaining();
        int newPosition = oldPosition + remaining;
        ByteBuffer buffer = this.buffer;
        int oldLimit = buffer.limit();
        if (0 > oldLimit - newPosition) {
            int oldCapacity = buffer.capacity();
            if (0 <= oldCapacity - newPosition) {
                assert (0 <= newPosition);
                buffer.limit(newPosition).position(oldPosition);
            } else {
                if (0 > newPosition) {
                    throw new OutOfMemoryError();
                }
                if (buffer.isReadOnly()) {
                    throw new NonWritableChannelException();
                }
                int newCapacity = oldCapacity << 1;
                if (0 > newCapacity - newPosition) {
                    newCapacity = newPosition;
                }
                if (0 > newCapacity) {
                    newCapacity = Integer.MAX_VALUE;
                }
                assert (newPosition <= newCapacity);
                this.buffer = buffer = (ByteBuffer)(buffer.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity)).put((ByteBuffer)buffer.position(0).limit(oldPosition)).limit(newPosition);
            }
        } else {
            buffer.position(oldPosition);
        }
        assert (buffer.position() == oldPosition);
        try {
            buffer.put(src);
        }
        catch (ReadOnlyBufferException ex) {
            throw new NonWritableChannelException();
        }
        assert (buffer.position() == newPosition);
        this.position = newPosition;
        return remaining;
    }

    @Override
    public long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    @Override
    public ByteBufferChannel position(long newPosition) throws IOException {
        this.checkOpen();
        if (0L > newPosition) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        this.checkOpen();
        return this.buffer.limit();
    }

    @Override
    public ByteBufferChannel truncate(long size2) throws IOException {
        this.checkOpen();
        if (this.buffer.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        if ((long)this.buffer.limit() > size2) {
            this.buffer.limit((int)size2);
        }
        if (this.position > size2) {
            this.position = size2;
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @DischargesObligation
    public void close() {
        this.closed = true;
    }
}

