/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.cio.InputService;
import net.java.truecommons.cio.IoBufferPool;
import net.java.truecommons.cio.OutputService;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Paths;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsInputSocketSource;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsOutputSocketSink;

@Immutable
public abstract class FsArchiveDriver<E extends FsArchiveEntry>
extends FsDriver {
    private final ThreadLocal<CharsetEncoder> encoder = new ThreadLocal();

    @Override
    public final FsController newController(FsManager context, FsModel model, @Nonnull FsController parent) {
        assert (parent.getModel().equals(model.getParent()));
        return context.newController(this, model, parent);
    }

    @Override
    public final boolean isArchiveDriver() {
        return true;
    }

    public FsController decorate(FsController controller2) {
        return controller2;
    }

    public abstract Charset getCharset();

    public final void checkEncodable(String name) throws CharConversionException {
        CharsetEncoder enc = this.encoder.get();
        if (null == enc) {
            enc = this.getCharset().newEncoder();
            this.encoder.set(enc);
        }
        if (!enc.canEncode(name)) {
            throw new CharConversionException(name + " (entry name not encodable with " + this.getCharset() + ")");
        }
    }

    public boolean getRedundantContentSupport() {
        return false;
    }

    public boolean getRedundantMetaDataSupport() {
        return false;
    }

    public abstract IoBufferPool getPool();

    @CreatesObligation
    public InputService<E> newInput(FsModel model, BitField<FsAccessOption> options, FsController controller2, FsNodeName name) throws IOException {
        return this.newInput(model, this.source(options, controller2, name));
    }

    @CreatesObligation
    protected abstract InputService<E> newInput(FsModel var1, FsInputSocketSource var2) throws IOException;

    @CreatesObligation
    public OutputService<E> newOutput(FsModel model, BitField<FsAccessOption> options, FsController controller2, FsNodeName name, @CheckForNull @WillNotClose InputService<E> input2) throws IOException {
        return this.newOutput(model, this.sink(options, controller2, name), input2);
    }

    @CreatesObligation
    protected abstract OutputService<E> newOutput(FsModel var1, FsOutputSocketSink var2, @CheckForNull @WillNotClose InputService<E> var3) throws IOException;

    protected FsInputSocketSource source(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        return new FsInputSocketSource(options, controller2.input(options, name));
    }

    protected FsOutputSocketSink sink(BitField<FsAccessOption> options, FsController controller2, FsNodeName name) {
        return new FsOutputSocketSink(options, controller2.output(options, name, null));
    }

    public final E newEntry(String name, Entry.Type type, @CheckForNull Entry template) {
        return this.newEntry(FsAccessOptions.NONE, name, type, template);
    }

    public abstract E newEntry(BitField<FsAccessOption> var1, String var2, Entry.Type var3, @CheckForNull Entry var4);

    public static String normalize(String name, Entry.Type type) {
        return Entry.Type.DIRECTORY == type ? (name.endsWith("/") ? name : name + '/') : Paths.cutTrailingSeparators(name, '/');
    }

    @Override
    public String toString() {
        return String.format("%s@%x[archiveDriver=%b, charset=%s, redundantContentSupport=%b, redundantMetaDataSupport=%b, pool=%s]", this.getClass().getName(), this.hashCode(), this.isArchiveDriver(), this.getCharset(), this.getRedundantContentSupport(), this.getRedundantMetaDataSupport(), this.getPool());
    }
}

