/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class LittleEndian {
    private LittleEndian() {
    }

    static byte readByte(byte[] buf, int off) {
        return buf[off];
    }

    static int readUByte(byte[] buf, int off) {
        return buf[off] & 0xFF;
    }

    static int readShort(byte[] buf, int off) {
        return buf[off + 1] << 8 | buf[off] & 0xFF;
    }

    static int readUShort(byte[] buf, int off) {
        return (buf[off + 1] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    static int readInt(byte[] buf, int off) {
        off += 3;
        int i = buf[off--];
        i <<= 8;
        i |= buf[off--] & 0xFF;
        i <<= 8;
        i |= buf[off--] & 0xFF;
        i <<= 8;
        return i |= buf[off] & 0xFF;
    }

    static long readUInt(byte[] buf, int off) {
        return (long)LittleEndian.readInt(buf, off) & 0xFFFFFFFFL;
    }

    static long readLong(byte[] buf, int off) {
        off += 7;
        long l = buf[off--];
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        l |= (long)(buf[off--] & 0xFF);
        l <<= 8;
        return l |= (long)(buf[off] & 0xFF);
    }

    static void writeByte(int b, byte[] buf, int off) {
        buf[off] = (byte)b;
    }

    static void writeShort(int s2, byte[] buf, int off) {
        buf[off] = (byte)s2;
        buf[off + 1] = (byte)(s2 >>= 8);
    }

    static void writeInt(int i, byte[] buf, int off) {
        buf[off] = (byte)i;
        buf[off + 1] = (byte)(i >>= 8);
        buf[off + 2] = (byte)(i >>= 8);
        buf[off + 3] = (byte)(i >>= 8);
    }

    static void writeLong(long l, byte[] buf, int off) {
        buf[off] = (byte)l;
        buf[off + 1] = (byte)(l >>= 8);
        buf[off + 2] = (byte)(l >>= 8);
        buf[off + 3] = (byte)(l >>= 8);
        buf[off + 4] = (byte)(l >>= 8);
        buf[off + 5] = (byte)(l >>= 8);
        buf[off + 6] = (byte)(l >>= 8);
        buf[off + 7] = (byte)(l >>= 8);
    }
}

