/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.comp.jmx.JmxManagerMXBean;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsControllerSyncVisitor;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncOptions;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

@ThreadSafe
public class JmxManagerView<M extends FsManager>
extends StandardMBean
implements JmxManagerMXBean {
    protected final M manager;

    public JmxManagerView(M manager) {
        this(JmxManagerMXBean.class, manager);
    }

    protected JmxManagerView(Class<? extends JmxManagerMXBean> type, M manager) {
        super(type, true);
        this.manager = (FsManager)Objects.requireNonNull(manager);
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A file system manager.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        switch (info.getName()) {
            case "FileSystemsMounted": {
                return "The number of file systems which have been mounted.";
            }
            case "FileSystemsTotal": {
                return "The total number of file systems.";
            }
            case "TopLevelArchiveFileSystemsMounted": {
                return "The number of top level archive file systems which have been mounted.";
            }
            case "TopLevelArchiveFileSystemsTotal": {
                return "The total number of top level archive file systems.";
            }
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        switch (info.getName()) {
            case "sync": {
                return "Synchronizes all file systems and eventually unmounts them.";
            }
        }
        return null;
    }

    @Override
    public int getFileSystemsTotal() {
        return this.count(Filter.ACCEPT_ANY);
    }

    @Override
    public int getFileSystemsMounted() {
        class FileSystemsMounted
        implements Filter<FsController> {
            FileSystemsMounted() {
            }

            @Override
            public boolean accept(FsController controller2) {
                return controller2.getModel().isMounted();
            }
        }
        return this.count(new FileSystemsMounted());
    }

    @Override
    public int getTopLevelArchiveFileSystemsTotal() {
        class TopLevelArchiveFileSystemsTotal
        implements Filter<FsController> {
            TopLevelArchiveFileSystemsTotal() {
            }

            @Override
            public boolean accept(FsController controller2) {
                return JmxManagerView.this.isTopLevelArchive(controller2);
            }
        }
        return this.count(new TopLevelArchiveFileSystemsTotal());
    }

    @Override
    public int getTopLevelArchiveFileSystemsMounted() {
        class TopLevelArchiveFileSystemsMounted
        implements Filter<FsController> {
            TopLevelArchiveFileSystemsMounted() {
            }

            @Override
            public boolean accept(FsController controller2) {
                return JmxManagerView.this.isTopLevelArchive(controller2) && controller2.getModel().isMounted();
            }
        }
        return this.count(new TopLevelArchiveFileSystemsMounted());
    }

    private int count(Filter<? super FsController> filter2) {
        class CountingVisitor
        extends AtomicInteger
        implements Visitor<FsController, IOException> {
            CountingVisitor() {
            }

            @Override
            public void visit(FsController controller2) {
                this.incrementAndGet();
            }
        }
        CountingVisitor visitor = new CountingVisitor();
        try {
            this.manager.visit(filter2, visitor);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return visitor.get();
    }

    private boolean isTopLevelArchive(FsController controller2) {
        FsController parent = controller2.getParent();
        return null != parent && null == parent.getParent();
    }

    @Override
    public void sync() throws FsSyncException {
        FsManagerLocator.SINGLETON.get().sync(Filter.ACCEPT_ANY, new FsControllerSyncVisitor(FsSyncOptions.NONE));
    }
}

