/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.swing;

import java.net.URI;
import javax.annotation.CheckForNull;
import net.java.truecommons.key.spec.prompting.PromptingPbeParameters;
import net.java.truecommons.key.swing.AuthenticationException;
import net.java.truecommons.key.swing.feedback.Feedback;
import net.java.truecommons.key.swing.util.EnhancedPanel;
import net.java.truecommons.key.swing.util.PanelEvent;
import net.java.truecommons.key.swing.util.PanelListener;

abstract class KeyPanel
extends EnhancedPanel {
    private static final long serialVersionUID = 0L;
    @CheckForNull
    private Feedback feedback;

    KeyPanel() {
        this.addPanelListener(new KeyPanelListener());
    }

    @CheckForNull
    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(@CheckForNull Feedback feedback) {
        this.feedback = feedback;
    }

    private void runFeedback() {
        Feedback feedback = this.getFeedback();
        if (null != feedback) {
            feedback.run(this);
        }
    }

    public abstract URI getResource();

    public abstract void setResource(URI var1);

    @CheckForNull
    public abstract String getError();

    public abstract void setError(@CheckForNull String var1);

    final boolean updateParam(PromptingPbeParameters<?, ?> param2) {
        try {
            this.updateParamChecked(param2);
            return true;
        }
        catch (AuthenticationException ex) {
            this.setError(ex.getLocalizedMessage());
            return false;
        }
    }

    abstract void updateParamChecked(PromptingPbeParameters<?, ?> var1) throws AuthenticationException;

    private static class KeyPanelListener
    implements PanelListener {
        private KeyPanelListener() {
        }

        @Override
        public void ancestorWindowShown(PanelEvent evt) {
            ((KeyPanel)evt.getSource()).runFeedback();
        }

        @Override
        public void ancestorWindowHidden(PanelEvent evt) {
        }
    }
}

