/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.beans.Transient;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.key.spec.AbstractSecretKey;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.PbeParameters;
import net.java.truecommons.shed.Buffers;

@NotThreadSafe
public abstract class AbstractPbeParameters<P extends AbstractPbeParameters<P, S>, S extends KeyStrength>
extends AbstractSecretKey<P>
implements PbeParameters<P, S> {
    @CheckForNull
    private S keyStrength;

    @Override
    public void reset() {
        super.reset();
        this.keyStrength = null;
    }

    @Override
    @Transient
    @Nullable
    public char[] getPassword() {
        return Buffers.charArray(this.getSecret());
    }

    @Override
    public void setPassword(@CheckForNull char[] password) {
        this.setSecret(Buffers.byteBuffer(password));
    }

    @Override
    @Transient
    @CheckForNull
    public S getKeyStrength() {
        return this.keyStrength;
    }

    @Override
    public void setKeyStrength(@CheckForNull S keyStrength) {
        this.keyStrength = keyStrength;
    }

    public int getKeyStrengthBits() {
        return null == this.keyStrength ? 0 : this.keyStrength.getBits();
    }

    public void setKeyStrengthBits(int bits2) {
        if (0 != bits2) {
            for (KeyStrength s2 : this.getAllKeyStrengths()) {
                if (s2.getBits() != bits2) continue;
                this.keyStrength = s2;
                return;
            }
            throw new IllegalArgumentException();
        }
        this.keyStrength = null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractPbeParameters that = (AbstractPbeParameters)obj;
        return Objects.equals(this.keyStrength, that.keyStrength);
    }

    @Override
    public int hashCode() {
        int c = super.hashCode();
        c = 31 * c + Objects.hashCode(this.keyStrength);
        return c;
    }

    @Override
    public String toString() {
        return String.format("%s[keystrength=%s]", super.toString(), this.keyStrength);
    }
}

