/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.zip;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;
import net.java.truecommons.io.LittleEndianOutputStream;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truevfs.comp.zip.WinZipAesCipher;
import net.java.truevfs.comp.zip.WinZipAesEntryParameters;
import net.java.truevfs.comp.zip.crypto.CipherOutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.io.MacOutputStream;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class WinZipAesOutputStream
extends DecoratingOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final WinZipAesEntryParameters param;
    private Mac mac;
    private LittleEndianOutputStream leos;

    WinZipAesOutputStream(WinZipAesEntryParameters param2, LittleEndianOutputStream leos) throws IOException {
        try {
            assert (null != leos);
            assert (null != param2);
            this.param = param2;
            AesKeyStrength keyStrength = param2.getKeyStrength();
            int keyStrengthBits = keyStrength.getBits();
            int keyStrengthBytes = keyStrength.getBytes();
            byte[] salt = new byte[keyStrengthBytes / 2];
            new SecureRandom().nextBytes(salt);
            byte[] passwd = param2.getWritePassword();
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
            gen.init(passwd, salt, 1000);
            assert (128 <= keyStrengthBits);
            KeyParameter keyParam = (KeyParameter)((PBEParametersGenerator)gen).generateDerivedParameters(2 * keyStrengthBits + 16);
            Arrays.fill(passwd, (byte)0);
            byte[] ctrIv = new byte[16];
            ParametersWithIV aesCtrParam = new ParametersWithIV(new KeyParameter(keyParam.getKey(), 0, keyStrengthBytes), ctrIv);
            KeyParameter sha1HMacParam = new KeyParameter(keyParam.getKey(), keyStrengthBytes, keyStrengthBytes);
            BufferedBlockCipher cipher = new BufferedBlockCipher(new WinZipAesCipher());
            cipher.init(true, aesCtrParam);
            this.mac = new HMac(new SHA1Digest());
            HMac mac = this.mac;
            mac.init(sha1HMacParam);
            this.leos = leos;
            this.out = new CipherOutputStream(cipher, new MacOutputStream(leos, mac));
            leos.write(salt);
            this.writePasswordVerifier(keyParam);
        }
        catch (Throwable ex) {
            try {
                leos.close();
            }
            catch (Throwable ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
    }

    private void writePasswordVerifier(KeyParameter keyParam) throws IOException {
        this.leos.write(keyParam.getKey(), 2 * this.param.getKeyStrength().getBytes(), 2);
    }

    void finish() throws IOException {
        ((CipherOutputStream)this.out).finish();
        Mac mac = this.mac;
        byte[] buf = new byte[mac.getMacSize()];
        int bufLength = mac.doFinal(buf, 0);
        assert (bufLength == buf.length);
        this.leos.write(buf, 0, bufLength / 2);
    }
}

