/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.io.MutableBuffer;
import net.java.truecommons.io.PowerBuffer;

@Immutable
public final class ImmutableBuffer
extends PowerBuffer<ImmutableBuffer> {
    private ImmutableBuffer(ByteBuffer buf) {
        super(buf);
    }

    public static ImmutableBuffer wrap(byte[] array) {
        return new ImmutableBuffer(ByteBuffer.wrap(array));
    }

    public static ImmutableBuffer wrap(byte[] array, int offset, int length) {
        return new ImmutableBuffer(ByteBuffer.wrap(array, offset, length));
    }

    public static ImmutableBuffer wrap(ByteBuffer buf) {
        return new ImmutableBuffer(ImmutableBuffer.clone(buf));
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public MutableBuffer asMutableBuffer() {
        return MutableBuffer.wrap(ImmutableBuffer.clone(this.bb));
    }

    @Override
    public ImmutableBuffer asImmutableBuffer() {
        return this;
    }

    @Override
    @Deprecated
    public ByteBuffer buffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer littleEndian() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer bigEndian() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer load(ReadableByteChannel channel2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer save(WritableByteChannel channel2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer skip(int skip) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getUByte() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getUShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public long getUInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer position(int newPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer limit(int newLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer flip() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableBuffer slice() {
        return new ImmutableBuffer(this.bb.slice());
    }

    @Override
    public ImmutableBuffer duplicate() {
        return new ImmutableBuffer(this.bb.duplicate());
    }

    @Override
    public ImmutableBuffer asReadOnlyBuffer() {
        return new ImmutableBuffer(this.bb.asReadOnlyBuffer());
    }

    @Override
    @Deprecated
    public byte get() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer put(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer get(byte[] dst, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer get(byte[] dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer put(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer put(byte[] src, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer put(byte[] src) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer compact() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer order(ByteOrder order) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public char getChar() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putChar(char value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public short getShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putShort(short value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putInt(int value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putLong(long value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public float getFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putFloat(float value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public double getDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableBuffer putDouble(double value2) {
        throw new UnsupportedOperationException();
    }
}

