/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.plug.openejb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.manager.core.UpdateResolver;
import net.java.trueupdate.manager.plug.openejb.Command;
import net.java.trueupdate.manager.plug.openejb.Files;
import net.java.trueupdate.manager.plug.openejb.InverseCommand;
import net.java.trueupdate.manager.plug.openejb.MacroCommand;
import net.java.trueupdate.manager.plug.openejb.RenameFileCommand;
import net.java.trueupdate.manager.plug.openejb.Scheme;
import net.java.trueupdate.manager.spec.UpdateDescriptor;
import net.java.trueupdate.manager.spec.UpdateMessage;
import net.java.trueupdate.shed.Objects;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;

@Immutable
class ConfiguredOpenEjbUpdateInstaller {
    private static final Logger logger = Logger.getLogger(ConfiguredOpenEjbUpdateInstaller.class.getName());
    private final Deployer deployer;
    private final UpdateMessage message;

    ConfiguredOpenEjbUpdateInstaller(Deployer deployer, UpdateMessage message) {
        this.deployer = (Deployer)Objects.requireNonNull((Object)deployer);
        this.message = (UpdateMessage)Objects.requireNonNull((Object)message);
    }

    void install(UpdateResolver resolver) throws Exception {
        AppInfo appInfo = this.resolveAppInfo();
        final File deploymentDir = new File(appInfo.path);
        if (!deploymentDir.isDirectory()) {
            throw new Exception("Deployment to an EAR or WAR file is not yet supported - please use a directory.");
        }
        logger.log(Level.FINE, "Resolved current location {0} to deployment directory {1} .", new Object[]{this.currentLocation(), deploymentDir});
        final File patchFile = resolver.resolveZipPatchFile(this.updateDescriptor());
        logger.log(Level.FINER, "Resolved patch ZIP file {0} for artifact descriptor {1} and update version {2} .", new Object[]{patchFile, this.artifactDescriptor(), this.updateVersion()});
        class PatchTask
        implements Files.FileTask {
            PatchTask() {
            }

            @Override
            public void execute(File inputFile) throws Exception {
                class RedeployTask
                implements Files.FileTask {
                    final /* synthetic */ File val$deploymentDir;

                    RedeployTask() {
                        this.val$deploymentDir = file;
                    }

                    @Override
                    public void execute(final File patchedJarFile) throws Exception {
                        final File updateDir = Files.createEmptySlot("update", ".dir");
                        final File backupDir = Files.createEmptySlot("backup", ".dir");
                        class UnjarUpdateCommand
                        implements Command {
                            UnjarUpdateCommand() {
                            }

                            @Override
                            public void execute() throws Exception {
                                Files.unzipTo(patchedJarFile, updateDir);
                            }

                            @Override
                            public void revert() throws Exception {
                                if (!Files.deleteAll(updateDir)) {
                                    throw new IOException(String.format("Cannot delete update directory %s .", updateDir));
                                }
                            }
                        }
                        final class DeployCommand
                        implements Command {
                            DeployCommand() {
                            }

                            @Override
                            public void execute() throws Exception {
                                ConfiguredOpenEjbUpdateInstaller.this.deployer.deploy(val$deploymentDir.getPath());
                            }

                            @Override
                            public void revert() throws Exception {
                                ConfiguredOpenEjbUpdateInstaller.this.deployer.undeploy(val$deploymentDir.getPath());
                            }
                        }
                        final class DeleteBackupCommand
                        implements Command {
                            DeleteBackupCommand() {
                            }

                            @Override
                            public void execute() throws Exception {
                                if (!Files.deleteAll(backupDir)) {
                                    throw new IOException(String.format("Cannot delete backup directory %s .", backupDir));
                                }
                            }

                            @Override
                            public void revert() throws Exception {
                                throw new AssertionError((Object)"This must be the last command and hence there is no need to ever revert it.");
                            }
                        }
                        new MacroCommand(new UnjarUpdateCommand(), new InverseCommand(new DeployCommand()), new RenameFileCommand(this.val$deploymentDir, backupDir), new RenameFileCommand(updateDir, this.val$deploymentDir), new DeployCommand(), new DeleteBackupCommand()).execute();
                    }
                }
                ConfiguredOpenEjbUpdateInstaller.loanPatchedFile(new RedeployTask(ConfiguredOpenEjbUpdateInstaller.this, deploymentDir), inputFile, patchFile);
            }
        }
        ConfiguredOpenEjbUpdateInstaller.loanInputFile(new PatchTask(), deploymentDir);
    }

    private AppInfo resolveAppInfo() throws FileNotFoundException {
        URI location = this.currentLocation();
        Scheme scheme = Scheme.valueOf(location.getScheme());
        for (AppInfo info : this.deployer.getDeployedApps()) {
            if (!scheme.matches(location, info)) continue;
            return info;
        }
        throw new FileNotFoundException(String.format("Cannot resolve application information for %s .", location));
    }

    private static void loanInputFile(final Files.FileTask task, final File deploymentDir) throws Exception {
        class MakeInputFile
        implements Files.FileTask {
            MakeInputFile() {
            }

            @Override
            public void execute(File inputFile) throws Exception {
                Files.zipTo(deploymentDir, inputFile);
                logger.log(Level.FINER, "Rebuilt input ZIP file {0} from deployment directory {1} .", new Object[]{inputFile, deploymentDir});
                task.execute(inputFile);
            }
        }
        Files.loanTempFileTo("input", ".zip", new MakeInputFile());
    }

    private static void loanPatchedFile(final Files.FileTask task, final File inputFile, final File patchFile) throws Exception {
        class MakePatchedFile
        implements Files.FileTask {
            MakePatchedFile() {
            }

            @Override
            public void execute(File patchedFile) throws Exception {
                Files.applyPatchTo(inputFile, patchFile, patchedFile);
                logger.log(Level.FINER, "Patched input ZIP file {0} with patch ZIP file {1} to patched JAR file {2} .", new Object[]{inputFile, patchFile, patchedFile});
                task.execute(patchedFile);
            }
        }
        Files.loanTempFileTo("patched", ".jar", new MakePatchedFile());
    }

    private ArtifactDescriptor artifactDescriptor() {
        return this.updateDescriptor().artifactDescriptor();
    }

    private String updateVersion() {
        return this.updateDescriptor().updateVersion();
    }

    private UpdateDescriptor updateDescriptor() {
        return this.message.updateDescriptor();
    }

    private URI currentLocation() {
        return this.message.currentLocation();
    }
}

