/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.io.File;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import net.java.truecommons.shed.PathNormalizer;
import net.java.truecommons.shed.PathSplitter;

@Immutable
public final class Paths {
    private Paths() {
    }

    public static String normalize(String path, char separatorChar) {
        return new PathNormalizer(separatorChar).normalize(path);
    }

    public static String cutTrailingSeparators(String path, char separatorChar) {
        int i = path.length();
        if (0 >= i || separatorChar != path.charAt(--i)) {
            return path;
        }
        while (0 < i && separatorChar == path.charAt(--i)) {
        }
        return path.substring(0, ++i);
    }

    public static PathSplitter split(String path, char separatorChar, boolean keepTrailingSeparator) {
        return new PathSplitter(separatorChar, keepTrailingSeparator).split(path);
    }

    public static boolean isRoot(String path) {
        return path.isEmpty();
    }

    public static boolean isAbsolute(String path, char separatorChar) {
        int prefixLen = Paths.prefixLength(path, separatorChar, false);
        return 0 < prefixLen && separatorChar == path.charAt(prefixLen - 1);
    }

    public static int prefixLength(String path, char separatorChar, boolean inclUNC) {
        int pathLen = path.length();
        if (pathLen <= 0) {
            return 0;
        }
        char c = path.charAt(0);
        if ('\\' == File.separatorChar) {
            if (2 <= pathLen && ':' == path.charAt(1) && ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                return 3 <= pathLen && separatorChar == path.charAt(2) ? 3 : 2;
            }
            if (separatorChar == c) {
                if (2 <= pathLen && separatorChar == path.charAt(1)) {
                    if (!inclUNC) {
                        return 2;
                    }
                    int i = path.indexOf(separatorChar, 2) + 1;
                    if (0 == i) {
                        return pathLen;
                    }
                    int j = path.indexOf(separatorChar, i) + 1;
                    if (0 == j) {
                        return pathLen;
                    }
                    return j;
                }
                return 1;
            }
            return 0;
        }
        return separatorChar == c ? 1 : 0;
    }

    public static boolean contains(String a, String b, char separatorChar) {
        int lengthB;
        if ('\\' == File.separatorChar) {
            a = a.toLowerCase(Locale.getDefault());
            b = b.toLowerCase(Locale.getDefault());
        }
        if (!b.startsWith(a)) {
            return false;
        }
        int lengthA = a.length();
        if (lengthA == (lengthB = b.length())) {
            return true;
        }
        if (lengthA < lengthB) {
            return b.charAt(lengthA) == separatorChar;
        }
        return false;
    }
}

