/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.Paths;

@NotThreadSafe
public class PathNormalizer {
    private final char separatorChar;
    private String path;
    private final StringBuilder buffer;

    public PathNormalizer(char separatorChar) {
        this.separatorChar = separatorChar;
        this.buffer = new StringBuilder();
    }

    public String normalize(String path) {
        String result;
        int prefixLen = Paths.prefixLength(path, this.separatorChar, false);
        int pathLen = path.length();
        this.path = path.substring(prefixLen, pathLen);
        this.buffer.setLength(0);
        this.buffer.ensureCapacity(pathLen);
        this.normalize(0, pathLen - prefixLen);
        this.buffer.insert(0, path.substring(0, prefixLen));
        int bufferLen = this.buffer.length();
        if (pathLen > 0 && path.charAt(pathLen - 1) == this.separatorChar || pathLen > 1 && path.charAt(pathLen - 2) == this.separatorChar && path.charAt(pathLen - 1) == '.') {
            this.slashify();
            bufferLen = this.buffer.length();
        }
        if (bufferLen == path.length()) {
            assert (path.equals(this.buffer.toString()));
            result = path;
        } else {
            result = this.buffer.toString();
            if (path.startsWith(result)) {
                result = path.substring(0, bufferLen);
            }
        }
        assert (!result.equals(path) || result == path);
        return result;
    }

    private int normalize(int collapse, int end) {
        int notCollapsed;
        assert (collapse >= 0);
        if (0 >= end) {
            return collapse;
        }
        int next = this.path.lastIndexOf(this.separatorChar, end - 1);
        String base = this.path.substring(next + 1, end);
        if (0 >= base.length() || ".".equals(base)) {
            return this.normalize(collapse, next);
        }
        if ("..".equals(base)) {
            notCollapsed = this.normalize(collapse + 1, next) - 1;
            if (0 > notCollapsed) {
                return 0;
            }
        } else {
            if (0 < collapse) {
                int notCollapsed2 = this.normalize(collapse - 1, next);
                this.slashify();
                return notCollapsed2;
            }
            assert (0 == collapse);
            notCollapsed = this.normalize(0, next);
            assert (0 == notCollapsed);
        }
        this.slashify();
        this.buffer.append(base);
        return notCollapsed;
    }

    private void slashify() {
        int bufferLen = this.buffer.length();
        if (bufferLen > 0 && this.buffer.charAt(bufferLen - 1) != this.separatorChar) {
            this.buffer.append(this.separatorChar);
        }
    }
}

