/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.writer.trex;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.FractionDigitsFacet;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.PatternFacet;
import com.sun.msv.datatype.xsd.RangeFacet;
import com.sun.msv.datatype.xsd.TotalDigitsFacet;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.WhiteSpaceFacet;
import com.sun.msv.datatype.xsd.WhiteSpaceProcessor;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AnyNameClass;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DifferenceNameClass;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.NameClassVisitor;
import com.sun.msv.grammar.NamespaceNameClass;
import com.sun.msv.grammar.NotNameClass;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.msv.writer.GrammarWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.LocatorImpl;

public class TREXWriter
implements GrammarWriter {
    protected Grammar grammar;
    protected Map exp2name;
    protected String defaultNs;
    protected DocumentHandler handler;
    protected NameClassVisitor nameClassWriter = this.createNameClassWriter();
    protected PatternWriter patternWriter = this.createPatternWriter();

    public void write(Grammar g) throws SAXException {
        this.write(g, this.sniffDefaultNs(g.getTopLevel()));
    }

    public void write(Grammar g, String defaultNs) throws SAXException {
        this.grammar = g;
        final HashSet nodes = new HashSet();
        final HashSet heads = new HashSet();
        g.getTopLevel().visit((ExpressionVisitorVoid)new ExpressionWalker(){

            public void onElement(ElementExp exp) {
                if (nodes.contains(exp)) {
                    heads.add(exp);
                    return;
                }
                nodes.add(exp);
                super.onElement(exp);
            }

            public void onRef(ReferenceExp exp) {
                if (nodes.contains(exp)) {
                    heads.add(exp);
                    return;
                }
                nodes.add(exp);
                super.onRef(exp);
            }
        });
        HashMap<String, Expression> name2exp = new HashMap<String, Expression>();
        int cnt = 0;
        for (Expression exp : heads) {
            if (exp instanceof ReferenceExp) {
                ReferenceExp rexp = (ReferenceExp)exp;
                if (rexp.name == null) {
                    while (name2exp.containsKey("anonymous" + cnt)) {
                        ++cnt;
                    }
                    name2exp.put("anonymous" + cnt, exp);
                    continue;
                }
                if (name2exp.containsKey(rexp.name)) {
                    int i = 2;
                    while (name2exp.containsKey(rexp.name + i)) {
                        ++i;
                    }
                    name2exp.put(rexp.name + i, exp);
                    continue;
                }
                name2exp.put(rexp.name, exp);
                continue;
            }
            if (exp instanceof ElementExp) {
                ElementExp eexp = (ElementExp)exp;
                NameClass nc = eexp.getNameClass();
                if (nc instanceof SimpleNameClass && !name2exp.containsKey(((SimpleNameClass)nc).localName)) {
                    name2exp.put(((SimpleNameClass)nc).localName, exp);
                    continue;
                }
                while (name2exp.containsKey("element" + cnt)) {
                    ++cnt;
                }
                name2exp.put("element" + cnt, exp);
                continue;
            }
            throw new Error();
        }
        this.exp2name = new HashMap();
        for (String name : name2exp.keySet()) {
            this.exp2name.put(name2exp.get(name), name);
        }
        try {
            this.handler.setDocumentLocator(new LocatorImpl());
            this.handler.startDocument();
            if (defaultNs != null) {
                this.start("grammar", new String[]{"ns", defaultNs, "xmlns", "http://www.thaiopensource.com/trex", "xmlns:trex", "http://www.thaiopensource.com/trex", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema-datatypes"});
            } else {
                this.start("grammar");
            }
            this.defaultNs = defaultNs;
            this.start("start");
            this.writeIsland(g.getTopLevel());
            this.end("start");
            for (Expression exp : this.exp2name.keySet()) {
                String name = (String)this.exp2name.get(exp);
                if (exp instanceof ReferenceExp) {
                    exp = ((ReferenceExp)exp).exp;
                }
                this.start("define", new String[]{"name", name});
                this.writeIsland(exp);
                this.end("define");
            }
            this.end("grammar");
            this.handler.endDocument();
        }
        catch (SAXWrapper sw) {
            throw sw.e;
        }
    }

    protected void writeIsland(Expression exp) {
        if (exp instanceof ElementExp) {
            this.patternWriter.writeElement((ElementExp)exp);
        } else {
            this.patternWriter.visitUnary(exp);
        }
    }

    protected String sniffDefaultNs(Expression exp) {
        return (String)exp.visit(new ExpressionVisitor(){

            public Object onElement(ElementExp exp) {
                return this.sniff(exp.getNameClass());
            }

            public Object onAttribute(AttributeExp exp) {
                return this.sniff(exp.nameClass);
            }

            protected String sniff(NameClass nc) {
                if (nc instanceof SimpleNameClass) {
                    return ((SimpleNameClass)nc).namespaceURI;
                }
                return null;
            }

            public Object onChoice(ChoiceExp exp) {
                return this.onBinExp((BinaryExp)exp);
            }

            public Object onSequence(SequenceExp exp) {
                return this.onBinExp((BinaryExp)exp);
            }

            public Object onInterleave(InterleaveExp exp) {
                return this.onBinExp((BinaryExp)exp);
            }

            public Object onConcur(ConcurExp exp) {
                return this.onBinExp((BinaryExp)exp);
            }

            public Object onBinExp(BinaryExp exp) {
                Object o = exp.exp1.visit((ExpressionVisitor)this);
                if (o == null) {
                    o = exp.exp2.visit((ExpressionVisitor)this);
                }
                return o;
            }

            public Object onMixed(MixedExp exp) {
                return exp.exp.visit((ExpressionVisitor)this);
            }

            public Object onOneOrMore(OneOrMoreExp exp) {
                return exp.exp.visit((ExpressionVisitor)this);
            }

            public Object onRef(ReferenceExp exp) {
                return exp.exp.visit((ExpressionVisitor)this);
            }

            public Object onOther(OtherExp exp) {
                return exp.exp.visit((ExpressionVisitor)this);
            }

            public Object onNullSet() {
                return null;
            }

            public Object onEpsilon() {
                return null;
            }

            public Object onAnyString() {
                return null;
            }

            public Object onList(ListExp exp) {
                return null;
            }

            public Object onData(DataExp exp) {
                return null;
            }

            public Object onValue(ValueExp exp) {
                return null;
            }
        });
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.handler = handler;
    }

    protected void element(String name) {
        this.element(name, new String[0]);
    }

    protected void element(String name, String[] attributes) {
        this.start(name, attributes);
        this.end(name);
    }

    protected void start(String name) {
        this.start(name, new String[0]);
    }

    protected void start(String name, String[] attributes) {
        AttributeListImpl as = new AttributeListImpl();
        for (int i = 0; i < attributes.length; i += 2) {
            as.addAttribute(attributes[i], "", attributes[i + 1]);
        }
        try {
            this.handler.startElement(name, as);
        }
        catch (SAXException e) {
            throw new SAXWrapper(e);
        }
    }

    protected void end(String name) {
        try {
            this.handler.endElement(name);
        }
        catch (SAXException e) {
            throw new SAXWrapper(e);
        }
    }

    protected void characters(String str) {
        try {
            this.handler.characters(str.toCharArray(), 0, str.length());
        }
        catch (SAXException e) {
            throw new SAXWrapper(e);
        }
    }

    protected NameClassVisitor createNameClassWriter() {
        return new NameClassWriter();
    }

    protected PatternWriter createPatternWriter() {
        return new PatternWriter();
    }

    protected class PatternWriter
    implements ExpressionVisitorVoid {
        protected PatternWriter() {
        }

        public void onOther(OtherExp exp) {
            exp.exp.visit((ExpressionVisitorVoid)this);
        }

        public void onRef(ReferenceExp exp) {
            String uniqueName = (String)TREXWriter.this.exp2name.get(exp);
            if (uniqueName != null) {
                TREXWriter.this.element("ref", new String[]{"name", uniqueName});
            } else {
                exp.exp.visit((ExpressionVisitorVoid)this);
            }
        }

        public void onElement(ElementExp exp) {
            String uniqueName = (String)TREXWriter.this.exp2name.get(exp);
            if (uniqueName != null) {
                TREXWriter.this.element("ref", new String[]{"name", uniqueName});
                return;
            }
            this.writeElement(exp);
        }

        public void writeElement(ElementExp exp) {
            NameClass nc = exp.getNameClass();
            if (nc instanceof SimpleNameClass && ((SimpleNameClass)nc).namespaceURI.equals(TREXWriter.this.defaultNs)) {
                TREXWriter.this.start("element", new String[]{"name", ((SimpleNameClass)nc).localName});
            } else {
                TREXWriter.this.start("element");
                exp.getNameClass().visit(TREXWriter.this.nameClassWriter);
            }
            this.visitUnary(this.simplify(exp.contentModel));
            TREXWriter.this.end("element");
        }

        public Expression simplify(Expression exp) {
            return exp.visit((ExpressionVisitorExpression)new ExpressionCloner(TREXWriter.this.grammar.getPool()){

                public Expression onRef(ReferenceExp exp) {
                    if (TREXWriter.this.exp2name.containsKey(exp)) {
                        return exp;
                    }
                    return exp.exp.visit((ExpressionVisitorExpression)this);
                }

                public Expression onElement(ElementExp exp) {
                    return exp;
                }

                public Expression onAttribute(AttributeExp exp) {
                    return exp;
                }

                public Expression onOther(OtherExp exp) {
                    return exp.exp.visit((ExpressionVisitorExpression)this);
                }
            });
        }

        public void onEpsilon() {
            TREXWriter.this.element("empty");
        }

        public void onNullSet() {
            TREXWriter.this.element("notAllowed");
        }

        public void onAnyString() {
            TREXWriter.this.element("anyString");
        }

        public void onInterleave(InterleaveExp exp) {
            this.visitBinExp("interleave", (BinaryExp)exp, InterleaveExp.class);
        }

        public void onConcur(ConcurExp exp) {
            this.visitBinExp("concur", (BinaryExp)exp, ConcurExp.class);
        }

        public void onList(ListExp exp) {
            throw new IllegalArgumentException("beyond the expressive power of TREX");
        }

        protected void onOptional(Expression exp) {
            if (exp instanceof OneOrMoreExp) {
                this.onZeroOrMore((OneOrMoreExp)exp);
                return;
            }
            TREXWriter.this.start("optional");
            this.visitUnary(exp);
            TREXWriter.this.end("optional");
        }

        public void onChoice(ChoiceExp exp) {
            if (exp.exp1 == Expression.epsilon) {
                this.onOptional(exp.exp2);
                return;
            }
            if (exp.exp2 == Expression.epsilon) {
                this.onOptional(exp.exp1);
                return;
            }
            this.visitBinExp("choice", (BinaryExp)exp, ChoiceExp.class);
        }

        public void onSequence(SequenceExp exp) {
            this.visitBinExp("group", (BinaryExp)exp, SequenceExp.class);
        }

        public void visitBinExp(String elementName, BinaryExp exp, Class type) {
            TREXWriter.this.start(elementName);
            Expression[] children = exp.getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].visit((ExpressionVisitorVoid)this);
            }
            TREXWriter.this.end(elementName);
        }

        public void onMixed(MixedExp exp) {
            TREXWriter.this.start("mixed");
            this.visitUnary(exp.exp);
            TREXWriter.this.end("mixed");
        }

        public void onOneOrMore(OneOrMoreExp exp) {
            TREXWriter.this.start("oneOrMore");
            this.visitUnary(exp.exp);
            TREXWriter.this.end("oneOrMore");
        }

        protected void onZeroOrMore(OneOrMoreExp exp) {
            TREXWriter.this.start("zeroOrMore");
            this.visitUnary(exp.exp);
            TREXWriter.this.end("zeroOrMore");
        }

        public void onAttribute(AttributeExp exp) {
            if (exp.nameClass instanceof SimpleNameClass && ((SimpleNameClass)exp.nameClass).namespaceURI.equals("")) {
                TREXWriter.this.start("attribute", new String[]{"name", ((SimpleNameClass)exp.nameClass).localName});
            } else {
                TREXWriter.this.start("attribute");
                exp.nameClass.visit(TREXWriter.this.nameClassWriter);
            }
            if (exp.exp != Expression.anyString) {
                this.visitUnary(exp.exp);
            }
            TREXWriter.this.end("attribute");
        }

        public void visitUnary(Expression exp) {
            if (exp instanceof SequenceExp) {
                SequenceExp seq = (SequenceExp)exp;
                seq.exp1.visit((ExpressionVisitorVoid)this);
                this.visitUnary(seq.exp2);
            } else {
                exp.visit((ExpressionVisitorVoid)this);
            }
        }

        protected void serializeDataType(XSDatatype dt) {
            String facetName;
            if (dt instanceof UnionType) {
                this.serializeUnionType((UnionType)dt);
                return;
            }
            if (dt instanceof ListType) {
                this.serializeListType((ListType)dt);
                return;
            }
            HashSet<String> appliedFacets = new HashSet<String>();
            XSDatatype x = dt;
            while (x instanceof DataTypeWithFacet && !appliedFacets.contains(facetName = ((DataTypeWithFacet)x).facetName)) {
                appliedFacets.add(facetName);
                x = ((DataTypeWithFacet)x).baseType;
            }
            if (!this.isBuiltinType((Datatype)x)) {
                TREXWriter.this.start("xsd:restriction");
                TREXWriter.this.start("xsd:simpleType");
                this.serializeDataType(x);
                TREXWriter.this.end("xsd:simpleType");
            } else {
                TREXWriter.this.start("xsd:restriction", new String[]{"base", "xsd:" + x.displayName()});
            }
            while (dt != x) {
                int i;
                DataTypeWithFacet dtf = (DataTypeWithFacet)dt;
                if (dtf instanceof LengthFacet) {
                    TREXWriter.this.element("xsd:length", new String[]{"value", Long.toString(((LengthFacet)dtf).length)});
                } else if (dtf instanceof MinLengthFacet) {
                    TREXWriter.this.element("xsd:minLength", new String[]{"value", Long.toString(((MinLengthFacet)dtf).minLength)});
                } else if (dtf instanceof MaxLengthFacet) {
                    TREXWriter.this.element("xsd:maxLength", new String[]{"value", Long.toString(((MaxLengthFacet)dtf).maxLength)});
                } else if (dtf instanceof PatternFacet) {
                    PatternFacet pf = (PatternFacet)dtf;
                    for (i = 0; i < pf.getRegExps().length; ++i) {
                        TREXWriter.this.element("xsd:pattern", new String[]{"value", pf.patterns[i]});
                    }
                } else if (dtf instanceof EnumerationFacet) {
                    Object[] values = ((EnumerationFacet)dtf).values.toArray();
                    for (i = 0; i < values.length; ++i) {
                        final Vector<String> ns = new Vector<String>();
                        String lex = dtf.convertToLexicalValue(values[i], new SerializationContext(){

                            public String getNamespacePrefix(String namespaceURI) {
                                int cnt = ns.size() / 2;
                                ns.add("xmlns:ns" + cnt);
                                ns.add(namespaceURI);
                                return "ns" + cnt;
                            }
                        });
                        ns.add("value");
                        ns.add(lex);
                        TREXWriter.this.element("xsd:enumeration", ns.toArray(new String[0]));
                    }
                } else if (dtf instanceof TotalDigitsFacet) {
                    TREXWriter.this.element("xsd:totalDigits", new String[]{"value", Long.toString(((TotalDigitsFacet)dtf).precision)});
                } else if (dtf instanceof FractionDigitsFacet) {
                    TREXWriter.this.element("xsd:fractionDigits", new String[]{"value", Long.toString(((FractionDigitsFacet)dtf).scale)});
                } else if (dtf instanceof RangeFacet) {
                    TREXWriter.this.element("xsd:" + dtf.facetName, new String[]{"value", dtf.convertToLexicalValue(((RangeFacet)dtf).limitValue, null)});
                } else if (dtf instanceof WhiteSpaceFacet) {
                    String value;
                    if (dtf.whiteSpace == WhiteSpaceProcessor.theCollapse) {
                        value = "collapse";
                    } else if (dtf.whiteSpace == WhiteSpaceProcessor.theReplace) {
                        value = "replace";
                    } else if (dtf.whiteSpace == WhiteSpaceProcessor.thePreserve) {
                        value = "preserve";
                    } else {
                        throw new Error();
                    }
                    TREXWriter.this.element("xsd:whiteSpace", new String[]{"value", value});
                } else {
                    throw new Error();
                }
                dt = ((DataTypeWithFacet)dt).baseType;
            }
            TREXWriter.this.end("xsd:restriction");
        }

        protected boolean isBuiltinType(Datatype x) {
            return !(x instanceof DataTypeWithFacet) && !(x instanceof UnionType) && !(x instanceof ListType);
        }

        protected void serializeUnionType(UnionType dt) {
            int i;
            String memberTypes = " ";
            for (i = 0; i < dt.memberTypes.length; ++i) {
                if (!this.isBuiltinType((Datatype)dt.memberTypes[i])) continue;
                memberTypes = memberTypes + "xsd:" + dt.memberTypes[i].getName() + " ";
            }
            if (memberTypes.equals(" ")) {
                TREXWriter.this.start("xsd:union");
            } else {
                TREXWriter.this.start("xsd:union", new String[]{"memberTypes", memberTypes});
            }
            for (i = 0; i < dt.memberTypes.length; ++i) {
                if (this.isBuiltinType((Datatype)dt.memberTypes[i])) continue;
                if (dt.getName() == null) {
                    TREXWriter.this.start("xsd:simpleType");
                } else {
                    TREXWriter.this.start("xsd:simpleType", new String[]{"name", dt.getName()});
                }
                this.serializeDataType((XSDatatype)dt.memberTypes[i]);
                TREXWriter.this.end("xsd:simpleType");
            }
            TREXWriter.this.end("xsd:union");
        }

        protected void serializeListType(ListType dt) {
            if (this.isBuiltinType((Datatype)dt.itemType)) {
                TREXWriter.this.element("xsd:list", new String[]{"itemType", "xsd:" + dt.itemType.getName()});
            } else {
                TREXWriter.this.start("xsd:list");
                TREXWriter.this.start("xsd:simpleType");
                this.serializeDataType((XSDatatype)dt.itemType);
                TREXWriter.this.end("xsd:simpleType");
                TREXWriter.this.end("xsd:list");
            }
        }

        public void onData(DataExp exp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void onValue(ValueExp exp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static class SAXWrapper
    extends RuntimeException {
        SAXException e;

        SAXWrapper(SAXException e) {
            this.e = e;
        }
    }

    protected class NameClassWriter
    implements NameClassVisitor {
        protected NameClassWriter() {
        }

        public Object onAnyName(AnyNameClass nc) {
            TREXWriter.this.element("anyName");
            return null;
        }

        protected void startWithNs(String name, String ns) {
            if (ns.equals(TREXWriter.this.defaultNs)) {
                TREXWriter.this.start(name);
            } else {
                TREXWriter.this.start(name, new String[]{"ns", ns});
            }
        }

        public Object onSimple(SimpleNameClass nc) {
            this.startWithNs("name", nc.namespaceURI);
            TREXWriter.this.characters(nc.localName);
            TREXWriter.this.end("name");
            return null;
        }

        public Object onNsName(NamespaceNameClass nc) {
            this.startWithNs("nsName", nc.namespaceURI);
            TREXWriter.this.end("nsName");
            return null;
        }

        public Object onNot(NotNameClass nc) {
            TREXWriter.this.start("not");
            nc.child.visit((NameClassVisitor)this);
            TREXWriter.this.end("not");
            return null;
        }

        public Object onChoice(ChoiceNameClass nc) {
            TREXWriter.this.start("choice");
            Stack<NameClass> s = new Stack<NameClass>();
            s.push(nc.nc1);
            s.push(nc.nc2);
            while (!s.empty()) {
                NameClass n = (NameClass)s.pop();
                if (n instanceof ChoiceNameClass) {
                    s.push(((ChoiceNameClass)n).nc1);
                    s.push(((ChoiceNameClass)n).nc2);
                    continue;
                }
                n.visit((NameClassVisitor)this);
            }
            TREXWriter.this.end("choice");
            return null;
        }

        public Object onDifference(DifferenceNameClass nc) {
            TREXWriter.this.start("difference");
            Stack<NameClass> s = new Stack<NameClass>();
            while (nc.nc1 instanceof DifferenceNameClass) {
                s.push(nc.nc2);
                nc = (DifferenceNameClass)nc.nc1;
            }
            nc.nc1.visit((NameClassVisitor)this);
            while (!s.empty()) {
                ((NameClass)s.pop()).visit((NameClassVisitor)this);
            }
            TREXWriter.this.end("difference");
            return null;
        }
    }
}

