/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.runtime.sm;

import com.sun.tahiti.runtime.sm.DOMMarshaller;
import com.sun.tahiti.runtime.sm.MarshallableObject;
import com.sun.tahiti.util.xml.SAXEventGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MarshallerAPI {
    private MarshallerAPI() {
    }

    public static Document marshallToDOM(MarshallableObject obj) throws ParserConfigurationException {
        DOMMarshaller dm = new DOMMarshaller();
        obj.marshall(dm);
        return dm.getResult();
    }

    public static void marshall(MarshallableObject obj, ContentHandler handler) throws ParserConfigurationException, SAXException {
        Document dom = MarshallerAPI.marshallToDOM(obj);
        SAXEventGenerator.parse(dom, handler);
    }

    public static void marshall(MarshallableObject obj, OutputStream out) throws ParserConfigurationException, IOException {
        MarshallerAPI.marshall(obj, out, "UTF-8", true);
    }

    public static void marshall(MarshallableObject obj, OutputStream out, String encoding, boolean indent) throws ParserConfigurationException, IOException {
        Document dom = MarshallerAPI.marshallToDOM(obj);
        new XMLSerializer(out, new OutputFormat("xml", encoding, indent)).serialize(dom);
    }

    public static void marshall(MarshallableObject obj, File out) throws ParserConfigurationException, IOException {
        MarshallerAPI.marshall(obj, new FileOutputStream(out));
    }

    public static void marshall(MarshallableObject obj, File out, String encoding, boolean indent) throws ParserConfigurationException, IOException {
        MarshallerAPI.marshall(obj, new FileOutputStream(out), encoding, indent);
    }

    public static void marshall(MarshallableObject obj, String fileName) throws ParserConfigurationException, IOException {
        MarshallerAPI.marshall(obj, new FileOutputStream(fileName));
    }

    public static void marshall(MarshallableObject obj, String fileName, String encoding, boolean indent) throws ParserConfigurationException, IOException {
        MarshallerAPI.marshall(obj, new FileOutputStream(fileName), encoding, indent);
    }
}

