/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.runtime.ll;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.verifier.psvi.TypedContentHandler;
import com.sun.tahiti.runtime.ll.BindableGrammar;
import com.sun.tahiti.runtime.ll.LLAttributeExp;
import com.sun.tahiti.runtime.ll.LLElementExp;
import com.sun.tahiti.runtime.ll.LLParser;
import com.sun.tahiti.runtime.ll.LLParserTable;
import com.sun.tahiti.runtime.ll.Packet;
import com.sun.tahiti.runtime.ll.UnmarshallingException;
import java.io.PrintStream;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.SAXException;

class Binder
implements TypedContentHandler {
    private static PrintStream debug = System.out;
    private Packet[] buffer = new Packet[16];
    private int bufLen;
    private int currentStartPos = 0;
    private int currentBodyPos;
    private int[] cpStack = new int[8];
    private int depth;
    private LLParser parser = new LLParser();
    private ValidationContext context;
    private final LLParserTable rootTable;
    private final Object rootSymbol;

    Binder() {
        this.rootSymbol = null;
        this.rootTable = null;
    }

    Binder(BindableGrammar grammar) {
        this.rootSymbol = grammar.getRootSymbol();
        this.rootTable = grammar.getRootTable();
    }

    private void initialize() {
        this.depth = 0;
        this.bufLen = 0;
        this.currentStartPos = 0;
        this.currentBodyPos = 0;
    }

    private void pushPacket(Packet p) {
        if (this.buffer.length == this.bufLen) {
            Packet[] newBuf = new Packet[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.bufLen++] = p;
        if (debug != null) {
            debug.println("pushPacket()");
        }
    }

    public void characterChunk(String literal, Datatype type) throws SAXException {
        System.out.println("characterChunk()");
        assert (type instanceof DatabindableDatatype);
        this.pushPacket(new Packet.DataPacket((DatabindableDatatype)type, literal));
    }

    private void processItem(Object targetSymbol, LLParserTable table) throws SAXException {
        Packet[] tokens = new Packet[this.bufLen - this.currentBodyPos];
        System.arraycopy(this.buffer, this.currentBodyPos, tokens, 0, tokens.length);
        Packet[] attributes = new Packet[this.currentBodyPos - this.currentStartPos];
        System.arraycopy(this.buffer, this.currentStartPos, attributes, 0, attributes.length);
        if (debug != null) {
            debug.println("target symbol - " + LLParser.symbolToStr(targetSymbol));
            debug.println("input packets (body:" + (this.bufLen - this.currentBodyPos) + ") (atts:" + (this.currentBodyPos - this.currentStartPos) + ")");
        }
        this.popContext();
        try {
            this.pushPacket(this.parser.unmarshall(targetSymbol, tokens, attributes, this.context, table));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnmarshallingException(e);
        }
        if (debug != null) {
            debug.println("item processed (" + ((Packet.ItemPacket)this.buffer[this.bufLen - 1]).getPayloadSize() + ")\n");
        }
    }

    private void pushContext() {
        if (this.depth == this.cpStack.length) {
            int[] newcp = new int[this.cpStack.length * 2];
            System.arraycopy(this.cpStack, 0, newcp, 0, this.cpStack.length);
            this.cpStack = newcp;
        }
        this.cpStack[this.depth++] = this.currentStartPos;
        this.cpStack[this.depth++] = this.currentBodyPos;
        this.currentStartPos = this.bufLen;
        this.currentBodyPos = 0;
    }

    private void popContext() {
        this.bufLen = this.currentStartPos;
        this.currentBodyPos = this.cpStack[--this.depth];
        this.currentStartPos = this.cpStack[--this.depth];
    }

    public void startElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (debug != null) {
            debug.println("startElement(" + namespaceURI + "," + localName + ")");
        }
        this.pushContext();
    }

    public void startAttribute(String namespaceURI, String localName, String qName) throws SAXException {
        if (debug != null) {
            debug.println("startAttribute(" + namespaceURI + "," + localName + ")");
        }
        this.pushContext();
        this.currentBodyPos = this.bufLen;
        if (debug != null) {
            debug.println("startAttribute(): currentBodyPos=" + this.currentBodyPos);
        }
    }

    public void endAttribute(String namespaceURI, String localName, String qName, AttributeExp type) throws SAXException {
        assert (type instanceof LLAttributeExp);
        this.processItem(type, ((LLAttributeExp)type).parserTable);
    }

    public void endAttributePart() throws SAXException {
        this.currentBodyPos = this.bufLen;
        if (debug != null) {
            debug.println("endAttributePart()   (currentBodyPos=" + this.currentBodyPos + ")");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName, ElementExp type) throws SAXException {
        assert (type instanceof LLElementExp);
        this.processItem(type, ((LLElementExp)type).parserTable);
    }

    public void startDocument(ValidationContext _context) throws SAXException {
        this.initialize();
        if (this.rootSymbol != null) {
            this.pushContext();
        }
        this.context = _context;
    }

    public void endDocument() throws SAXException {
        if (this.rootSymbol != null) {
            this.processItem(this.rootSymbol, this.rootTable);
        }
        assert (this.bufLen == 1);
    }

    public Object getResult() {
        Object[] theResult;
        block2: {
            Packet.ItemPacket top = (Packet.ItemPacket)this.buffer[0];
            theResult = new Object[1];
            try {
                top.dispatch(new LLParser.ObjectReceiver(){

                    @Override
                    public void start() {
                    }

                    @Override
                    public void end() {
                    }

                    @Override
                    public void action(Object item) {
                        if (theResult[0] != null) {
                            throw new Error();
                        }
                        theResult[0] = item;
                    }
                }, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return theResult[0];
    }
}

