/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.annotator;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionCloner;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.JavaItemVisitor;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.SuperClassItem;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class TemporaryClassItemRemover {
    private static PrintStream debug = System.out;

    TemporaryClassItemRemover() {
    }

    public static void remove(AnnotatedGrammar grammar) {
        Pass1 p1 = new Pass1();
        grammar.topLevel.visit((ExpressionVisitorVoid)p1);
        HashSet cs = new HashSet(grammar.classes.values());
        cs.removeAll(p1.notRemovableClasses);
        Iterator itr = cs.iterator();
        while (itr.hasNext()) {
            if (((ClassItem)itr.next()).isTemporary) continue;
            itr.remove();
        }
        if (debug != null) {
            for (ClassItem ci : cs) {
                debug.println(" " + ci.getTypeName() + " will be removed");
            }
        }
        grammar.topLevel = grammar.topLevel.visit((ExpressionVisitorExpression)new Pass2(grammar.getPool(), cs));
        grammar.removeClassItems(cs);
    }

    private static class Pass1
    extends ExpressionWalker
    implements JavaItemVisitor {
        private final Set checkedClasses = new HashSet();
        final Set notRemovableClasses = new HashSet();
        private Set childItems = new HashSet();
        private JavaItem parentItem;

        private Pass1() {
        }

        public void onOther(OtherExp exp) {
            if (!(exp instanceof JavaItem)) {
                super.onOther(exp);
                return;
            }
            ((JavaItem)exp).visitJI(this);
        }

        @Override
        public Object onIgnore(IgnoreItem item) {
            return null;
        }

        @Override
        public Object onField(FieldItem item) {
            super.onOther((OtherExp)item);
            return null;
        }

        @Override
        public Object onSuper(SuperClassItem item) {
            this.updateAndVisit(item);
            return null;
        }

        @Override
        public Object onInterface(InterfaceItem item) {
            this.updateAndVisit(item);
            return null;
        }

        private void updateAndVisit(JavaItem item) {
            this.childItems.add(item);
            JavaItem old = this.parentItem;
            this.parentItem = item;
            super.onOther((OtherExp)item);
            this.parentItem = old;
        }

        @Override
        public Object onPrimitive(PrimitiveItem item) {
            this.childItems.add(item);
            return null;
        }

        @Override
        public Object onClass(ClassItem item) {
            this.childItems.add(item);
            if ((this.parentItem instanceof SuperClassItem || this.parentItem instanceof InterfaceItem) && this.notRemovableClasses.add(item) && debug != null) {
                debug.println(item.getTypeName() + " : referenced by a superClass/interfaceItem");
            }
            if (!this.checkedClasses.add(item)) {
                if (this.notRemovableClasses.add(item) && debug != null) {
                    debug.println(item.getTypeName() + " : referenced more than once");
                }
                return null;
            }
            Set oldChildItems = this.childItems;
            this.childItems = new HashSet();
            JavaItem oldParent = this.parentItem;
            this.parentItem = item;
            super.onOther((OtherExp)item);
            if (this.childItems.size() == 0) {
                if (this.notRemovableClasses.add(item) && debug != null) {
                    debug.println(item.getTypeName() + " : this class has no child item");
                }
            } else if (this.childItems.size() > 1 && this.notRemovableClasses.add(item) && debug != null) {
                debug.println(item.getTypeName() + " : this class has multiple fields");
            }
            this.childItems = oldChildItems;
            this.parentItem = oldParent;
            return null;
        }
    }

    private static class Pass2
    extends ExpressionCloner {
        private final Set targets;
        private final Set visitedExps = new HashSet();

        Pass2(ExpressionPool pool, Set targets) {
            super(pool);
            this.targets = targets;
        }

        public Expression onNullSet() {
            throw new Error();
        }

        public Expression onConcur(ConcurExp exp) {
            throw new Error();
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression body = exp.exp.visit((ExpressionVisitorExpression)this);
            if (body == exp.exp) {
                return exp;
            }
            return this.pool.createAttribute(exp.nameClass, body, exp.getDefaultValue());
        }

        public Expression onElement(ElementExp exp) {
            if (!this.visitedExps.add(exp)) {
                return exp;
            }
            exp.contentModel = exp.contentModel.visit((ExpressionVisitorExpression)this);
            return exp;
        }

        public Expression onRef(ReferenceExp exp) {
            if (!this.visitedExps.add(exp)) {
                return exp;
            }
            exp.exp = exp.exp.visit((ExpressionVisitorExpression)this);
            return exp;
        }

        public Expression onOther(OtherExp exp) {
            if (this.targets.contains(exp)) {
                if (debug != null) {
                    debug.println(" " + ((ClassItem)exp).getTypeName() + ": found and removed");
                }
                return exp.exp.visit((ExpressionVisitorExpression)this);
            }
            exp.exp = exp.exp.visit((ExpressionVisitorExpression)this);
            return exp;
        }
    }
}

