/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.reader.annotator;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.util.ExpressionPrinter;
import com.sun.msv.reader.GrammarReader;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.FieldUse;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.InterfaceItem;
import com.sun.tahiti.grammar.JavaItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.SuperClassItem;
import com.sun.tahiti.grammar.Type;
import com.sun.tahiti.grammar.TypeItem;
import com.sun.tahiti.grammar.util.Multiplicity;
import com.sun.tahiti.grammar.util.MultiplicityCounter;
import com.sun.tahiti.reader.TypeUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.xml.sax.Locator;

class RelationNormalizer {
    private final GrammarReader reader;
    public static final String ERR_BAD_SUPERCLASS_USE = "Normalizer.BadSuperClassUse";
    public static final String ERR_BAD_ITEM_USE = "Normalizer.BadItemUse";
    public static final String ERR_MULTIPLE_SUPERCLASS_BODY = "Normalizer.MultipleSuperClassBody";
    public static final String ERR_MULTIPLE_INHERITANCE = "Normalizer.MultipleInheritance";
    public static final String ERR_MISSING_SUPERCLASS_BODY = "Normalizer.MissingSuperClassBody";
    public static final String ERR_BAD_SUPERCLASS_MULTIPLICITY = "Normalizer.BadSuperClassMultiplicity";
    public static final String ERR_BAD_SUPERCLASS_BODY_MULTIPLICITY = "Normalizer.BadSuperClassBodyMultiplicity";
    public static final String ERR_BAD_INTERFACE_CLASS_MULTIPLICITY = "Normalizer.BadInterfaceToClassMultiplicity";

    private RelationNormalizer(GrammarReader reader) {
        this.reader = reader;
    }

    public static void normalize(GrammarReader reader, AnnotatedGrammar grammar) {
        int i;
        RelationNormalizer n = new RelationNormalizer(reader);
        ClassItem[] classItems = grammar.getClasses();
        RelationNormalizer relationNormalizer = n;
        Objects.requireNonNull(relationNormalizer);
        Pass1 pass1 = relationNormalizer.new Pass1();
        grammar.topLevel = grammar.topLevel.visit((ExpressionVisitorExpression)pass1);
        for (i = 0; i < classItems.length; ++i) {
            classItems[i].visit(pass1);
        }
        for (i = 0; i < classItems.length; ++i) {
            FieldUse[] fieldUses = classItems[i].fields.values().toArray(new FieldUse[0]);
            for (int j = 0; j < fieldUses.length; ++j) {
                FieldUse fieldUse = fieldUses[j];
                Expression expression = classItems[i].exp;
                RelationNormalizer relationNormalizer2 = n;
                Objects.requireNonNull(relationNormalizer2);
                fieldUse.multiplicity = (Multiplicity)expression.visit((ExpressionVisitor)relationNormalizer2.new Pass2(fieldUses[j]));
                HashSet possibleTypes = new HashSet();
                FieldItem[] fields = fieldUses[j].items.toArray(new FieldItem[0]);
                for (int k = 0; k < fields.length; ++k) {
                    possibleTypes.addAll(fields[k].types);
                }
                fieldUses[j].type = TypeUtil.getCommonBaseType(possibleTypes.toArray(new Type[0]));
            }
        }
    }

    private static boolean isClass(Object exp) {
        return exp instanceof ClassItem;
    }

    private static boolean isSuperClass(Object exp) {
        return exp instanceof SuperClassItem;
    }

    private static boolean isInterface(Object exp) {
        return exp instanceof InterfaceItem;
    }

    private static boolean isField(Object exp) {
        return exp instanceof FieldItem;
    }

    private static boolean isType(Object exp) {
        return exp instanceof TypeItem;
    }

    private static boolean isPrimitive(Object exp) {
        return exp instanceof PrimitiveItem;
    }

    private static boolean isIgnore(Object exp) {
        return exp instanceof IgnoreItem;
    }

    private class Pass1
    implements ExpressionVisitorExpression {
        private final Set visitedClasses = new HashSet();
        private JavaItem parentItem = null;
        private Multiplicity multiplicity = null;

        private Pass1() {
        }

        public Expression onAttribute(AttributeExp exp) {
            Expression newContent = exp.exp.visit((ExpressionVisitorExpression)this);
            if (newContent != exp.exp) {
                return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createAttribute(exp.getNameClass(), newContent, exp.getDefaultValue());
            }
            return exp;
        }

        public Expression onElement(ElementExp exp) {
            Expression body = exp.contentModel.visit((ExpressionVisitorExpression)this);
            if (body == exp.contentModel) {
                return exp;
            }
            return new ElementPattern(exp.getNameClass(), body);
        }

        public Expression onMixed(MixedExp exp) {
            return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createMixed(exp.exp.visit((ExpressionVisitorExpression)this));
        }

        public Expression onList(ListExp exp) {
            return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createList(exp.exp.visit((ExpressionVisitorExpression)this));
        }

        public Expression onConcur(ConcurExp exp) {
            throw new Error("concur is not supported");
        }

        public Expression onChoice(ChoiceExp exp) {
            Expression lhs = exp.exp1.visit((ExpressionVisitorExpression)this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit((ExpressionVisitorExpression)this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.choice(lhc, rhc);
            return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createChoice(lhs, rhs);
        }

        public Expression onSequence(SequenceExp exp) {
            Expression lhs = exp.exp1.visit((ExpressionVisitorExpression)this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit((ExpressionVisitorExpression)this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.group(lhc, rhc);
            return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createSequence(lhs, rhs);
        }

        public Expression onInterleave(InterleaveExp exp) {
            Expression lhs = exp.exp1.visit((ExpressionVisitorExpression)this);
            Multiplicity lhc = this.multiplicity;
            Expression rhs = exp.exp2.visit((ExpressionVisitorExpression)this);
            Multiplicity rhc = this.multiplicity;
            this.multiplicity = Multiplicity.group(lhc, rhc);
            return ((RelationNormalizer)RelationNormalizer.this).reader.pool.createInterleave(lhs, rhs);
        }

        public Expression onOneOrMore(OneOrMoreExp exp) {
            Expression p = ((RelationNormalizer)RelationNormalizer.this).reader.pool.createOneOrMore(exp.exp.visit((ExpressionVisitorExpression)this));
            this.multiplicity = Multiplicity.oneOrMore(this.multiplicity);
            return p;
        }

        public Expression onEpsilon() {
            this.multiplicity = Multiplicity.zero;
            return Expression.epsilon;
        }

        public Expression onNullSet() {
            throw new Error();
        }

        public Expression onAnyString() {
            throw new Error();
        }

        public Expression onData(DataExp exp) {
            this.multiplicity = Multiplicity.zero;
            return exp;
        }

        public Expression onValue(ValueExp exp) {
            this.multiplicity = Multiplicity.zero;
            return exp;
        }

        public Expression onRef(ReferenceExp exp) {
            return exp.exp.visit((ExpressionVisitorExpression)this);
        }

        public Expression onOther(OtherExp exp) {
            if (!(exp instanceof JavaItem)) {
                return exp.exp.visit((ExpressionVisitorExpression)this);
            }
            if (RelationNormalizer.isIgnore((Object)this.parentItem)) {
                return exp.exp.visit((ExpressionVisitorExpression)this);
            }
            JavaItem old = this.parentItem;
            if (exp instanceof JavaItem) {
                this.sanityCheck(this.parentItem, (JavaItem)exp);
                if (RelationNormalizer.isSuperClass((Object)this.parentItem) && RelationNormalizer.isClass(exp)) {
                    this.setSuperClassBody((SuperClassItem)this.parentItem, (ClassItem)exp);
                }
                if (RelationNormalizer.isInterface((Object)this.parentItem) && RelationNormalizer.isType(exp)) {
                    this.setImplementedInterface((TypeItem)exp, (InterfaceItem)this.parentItem);
                }
                if (RelationNormalizer.isClass((Object)this.parentItem) && RelationNormalizer.isSuperClass(exp)) {
                    this.setSuperClassForClass((ClassItem)this.parentItem, (SuperClassItem)exp);
                }
                if (RelationNormalizer.isClass((Object)this.parentItem) && RelationNormalizer.isField(exp)) {
                    FieldItem fi = (FieldItem)exp;
                    ((ClassItem)this.parentItem).getFieldUse((String)fi.name).items.add(fi);
                }
                if (RelationNormalizer.isField((Object)this.parentItem) && exp instanceof Type) {
                    ((FieldItem)this.parentItem).types.add(exp);
                }
                if (!this.visitedClasses.add(exp)) {
                    this.multiplicity = this.getJavaItemMultiplicity(exp);
                    return exp;
                }
                this.parentItem = (JavaItem)exp;
            }
            exp.exp = exp.exp.visit((ExpressionVisitorExpression)this);
            this.parentItem = old;
            if (RelationNormalizer.isSuperClass(exp)) {
                SuperClassItem sci = (SuperClassItem)exp;
                if (sci.definition == null) {
                    RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)exp)}, RelationNormalizer.ERR_MISSING_SUPERCLASS_BODY, null);
                } else if (!this.multiplicity.isUnique()) {
                    RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)exp), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)sci.definition)}, RelationNormalizer.ERR_BAD_SUPERCLASS_BODY_MULTIPLICITY, new Object[]{sci.definition.name});
                }
            }
            if (RelationNormalizer.isField(exp)) {
                ((FieldItem)exp).multiplicity = this.multiplicity;
            }
            if (RelationNormalizer.isInterface(exp)) {
                InterfaceItem ii = (InterfaceItem)exp;
                if (!this.multiplicity.isAtMostOnce()) {
                    System.out.println(ExpressionPrinter.printContentModel((Expression)exp.exp));
                    RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)ii)}, RelationNormalizer.ERR_BAD_INTERFACE_CLASS_MULTIPLICITY, new Object[]{ii.name});
                }
                return exp;
            }
            this.multiplicity = this.getJavaItemMultiplicity(exp);
            return exp;
        }

        private Multiplicity getJavaItemMultiplicity(OtherExp item) {
            if (item instanceof IgnoreItem) {
                return Multiplicity.zero;
            }
            return Multiplicity.one;
        }

        private void sanityCheck(JavaItem parent, JavaItem child) {
            if (RelationNormalizer.isSuperClass((Object)parent) && !RelationNormalizer.isClass((Object)child)) {
                RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)parent), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)child)}, RelationNormalizer.ERR_BAD_SUPERCLASS_USE, null);
                return;
            }
            if (RelationNormalizer.isPrimitive((Object)parent)) {
                throw new Error("internal error: use of primitive-* relation.");
            }
            if (RelationNormalizer.isField((Object)parent) && (RelationNormalizer.isSuperClass((Object)child) || RelationNormalizer.isField((Object)child)) || RelationNormalizer.isInterface((Object)parent) && (RelationNormalizer.isSuperClass((Object)child) || RelationNormalizer.isField((Object)child) || RelationNormalizer.isPrimitive((Object)child))) {
                RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)parent), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)child)}, RelationNormalizer.ERR_BAD_ITEM_USE, null);
                return;
            }
            if (RelationNormalizer.isClass((Object)parent) && child instanceof Type) {
                throw new Error("internal error. C-C/C-I/C-P relation " + ((ClassItem)parent).getTypeName() + " " + ((Object)((Object)child)).toString() + " " + ExpressionPrinter.printContentModel((Expression)parent));
            }
        }

        protected void setSuperClassForClass(ClassItem p, SuperClassItem c) {
            if (p.superClass != null) {
                RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)p), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)p.superClass), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)c)}, RelationNormalizer.ERR_MULTIPLE_INHERITANCE, new Object[]{p.name});
                return;
            }
            p.superClass = c;
        }

        protected void setSuperClassBody(SuperClassItem parent, ClassItem child) {
            if (parent.definition != null) {
                RelationNormalizer.this.reader.reportError(new Locator[]{RelationNormalizer.this.reader.getDeclaredLocationOf((Object)parent), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)child), RelationNormalizer.this.reader.getDeclaredLocationOf((Object)parent.definition)}, RelationNormalizer.ERR_MULTIPLE_SUPERCLASS_BODY, null);
                return;
            }
            parent.definition = child;
        }

        protected void setImplementedInterface(TypeItem c, InterfaceItem i) {
            c.interfaces.add(i);
        }
    }

    private class Pass2
    extends MultiplicityCounter {
        private final FieldUse fieldUse;

        Pass2(FieldUse fieldUse) {
            this.fieldUse = fieldUse;
        }

        @Override
        protected Multiplicity isChild(Expression exp) {
            if (this.fieldUse.items.contains(exp)) {
                if (((FieldItem)exp).multiplicity == null) {
                    throw new Error("internal error");
                }
                return ((FieldItem)exp).multiplicity;
            }
            if (exp instanceof JavaItem) {
                return Multiplicity.zero;
            }
            return null;
        }
    }
}

