/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.tahiti.compiler.ll.Rule;
import com.sun.tahiti.compiler.ll.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Rules {
    private final Map distinctiveRules = new HashMap();
    private final Map rules = new HashMap();

    public Set get(Expression symbol) {
        HashSet s = (HashSet)this.rules.get(symbol);
        if (s == null) {
            s = new HashSet();
            this.rules.put(symbol, s);
        }
        return s;
    }

    public Rule[] getAll(Expression symbol) {
        return this.get(symbol).toArray(new Rule[0]);
    }

    public boolean contains(Expression symbol) {
        Set s = (Set)this.rules.get(symbol);
        if (s == null) {
            return false;
        }
        return s.size() != 0;
    }

    public Iterator iterateKeys() {
        return this.rules.keySet().iterator();
    }

    Rule unifyRule(Rule r) {
        Rule unified = (Rule)this.distinctiveRules.get(r);
        if (unified == null) {
            unified = r;
            this.distinctiveRules.put(unified, r);
        }
        return unified;
    }

    public void add(Expression left, Rule right) {
        this.get(left).add(this.unifyRule(right));
    }

    public void add(Expression left, Expression[] right, boolean isInterleave) {
        this.add(left, new Rule(right, isInterleave));
    }

    public void add(Expression left, Expression right) {
        this.add(left, new Expression[]{right}, false);
    }

    public void addAll(Expression left, Rule[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            this.add(left, rules[i]);
        }
    }

    public void intern() {
        HashMap distinctRules = new HashMap();
        HashSet<Rule> temp = new HashSet<Rule>();
        Iterator itr = this.iterateKeys();
        while (itr.hasNext()) {
            Set s = this.get((Expression)itr.next());
            temp.clear();
            for (Rule r : s) {
                Rule unified = (Rule)this.distinctiveRules.get(r);
                if (unified == null) {
                    this.distinctiveRules.put(r, r);
                    unified = r;
                }
                temp.add(unified);
            }
            s.clear();
            s.addAll(temp);
        }
    }

    public Rules removeUnreachableRules(Expression rootSymbol, boolean recurseElement) {
        Rules result = new Rules();
        HashSet<Expression> workQueue = new HashSet<Expression>();
        workQueue.add(rootSymbol);
        while (!workQueue.isEmpty()) {
            Expression symbol = (Expression)workQueue.iterator().next();
            workQueue.remove(symbol);
            Rule[] rs = this.getAll(symbol);
            assert (rs != null && rs.length != 0);
            result.addAll(symbol, rs);
            for (int i = 0; i < rs.length; ++i) {
                for (int j = 0; j < rs[i].right.length; ++j) {
                    Expression e = rs[i].right[j];
                    if (Util.isTerminalSymbol(e) || result.contains(e) || !recurseElement && e instanceof NameClassAndExpression) continue;
                    workQueue.add(e);
                    assert (e != null);
                }
            }
        }
        return result;
    }
}

