/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.DataOrValueExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.util.ExpressionWalker;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.ll.ExpressionSerializer;
import com.sun.tahiti.compiler.ll.LLTableCalculator;
import com.sun.tahiti.compiler.ll.Rule;
import com.sun.tahiti.compiler.ll.Rules;
import com.sun.tahiti.grammar.AnnotatedGrammar;
import com.sun.tahiti.grammar.ClassItem;
import com.sun.tahiti.grammar.FieldItem;
import com.sun.tahiti.grammar.IgnoreItem;
import com.sun.tahiti.grammar.PrimitiveItem;
import com.sun.tahiti.grammar.Type;
import com.sun.tahiti.grammar.TypeItem;
import com.sun.tahiti.reader.NameUtil;
import com.sun.tahiti.reader.TypeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.relaxng.datatype.Datatype;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class RuleSerializer
implements Symbolizer {
    final Map allNames = new HashMap();

    private RuleSerializer() {
    }

    public static Symbolizer serialize(AnnotatedGrammar grammar, Rules rules, DocumentHandler outHandler) throws SAXException {
        RuleSerializer gen = new RuleSerializer();
        gen._serialize(grammar, rules, outHandler);
        return gen;
    }

    @Override
    public String getId(Object symbol) {
        if (symbol == null) {
            return "null";
        }
        String s = (String)this.allNames.get(symbol);
        if (s == null) {
            System.out.println(symbol);
            assert (false);
        }
        return s;
    }

    private void _serialize(AnnotatedGrammar grammar, Rules rules, DocumentHandler outHandler) throws SAXException {
        this.allNames.put(Expression.epsilon, "epsilon");
        try {
            int i;
            int i2;
            XMLWriter out = new XMLWriter(outHandler);
            outHandler.setDocumentLocator(new LocatorImpl());
            outHandler.startDocument();
            outHandler.processingInstruction("xml-stylesheet", "type='text/xsl' href='../grammarDebug.xslt'");
            out.start("grammar");
            int idx = grammar.grammarName.lastIndexOf(46);
            if (idx < 0) {
                out.element("name", grammar.grammarName);
            } else {
                out.element("package", grammar.grammarName.substring(0, idx));
                out.element("name", grammar.grammarName.substring(idx + 1));
            }
            final HashMap elements = new HashMap();
            final HashMap attributes = new HashMap();
            final HashMap datatypes = new HashMap();
            final HashMap classes = new HashMap();
            final HashMap fields = new HashMap();
            final HashMap primitives = new HashMap();
            final HashMap ignores = new HashMap();
            grammar.getTopLevel().visit((ExpressionVisitorVoid)new ExpressionWalker(){

                public void onElement(ElementExp exp) {
                    if (!elements.containsKey(exp)) {
                        elements.put(exp, RuleSerializer.computeName(exp.getNameClass(), elements));
                        super.onElement(exp);
                    }
                }

                public void onAttribute(AttributeExp exp) {
                    if (!attributes.containsKey(exp)) {
                        attributes.put(exp, RuleSerializer.computeName(exp.nameClass, attributes));
                        super.onAttribute(exp);
                    }
                }

                public void onData(DataExp exp) {
                    if (!datatypes.containsKey(exp)) {
                        datatypes.put(exp, RuleSerializer.computeName(exp.dt, datatypes));
                        super.onData(exp);
                    }
                }

                public void onValue(ValueExp exp) {
                    if (!datatypes.containsKey(exp)) {
                        datatypes.put(exp, RuleSerializer.computeName(exp.dt, datatypes));
                        super.onValue(exp);
                    }
                }

                public void onOther(OtherExp exp) {
                    if (exp instanceof ClassItem) {
                        if (!classes.containsKey(exp)) {
                            classes.put(exp, RuleSerializer.computeName((ClassItem)exp, classes));
                            super.onOther(exp);
                        }
                        return;
                    }
                    if (exp instanceof PrimitiveItem) {
                        if (!primitives.containsKey(exp)) {
                            primitives.put(exp, RuleSerializer.computeName((PrimitiveItem)exp, primitives));
                            super.onOther(exp);
                        }
                        return;
                    }
                    if (exp instanceof FieldItem) {
                        if (!fields.containsKey(exp)) {
                            fields.put(exp, RuleSerializer.computeName((FieldItem)exp, fields));
                            super.onOther(exp);
                        }
                        return;
                    }
                    if (exp instanceof IgnoreItem) {
                        if (!ignores.containsKey(exp)) {
                            ignores.put(exp, RuleSerializer.computeName((IgnoreItem)exp, ignores));
                            super.onOther(exp);
                        }
                        return;
                    }
                    super.onOther(exp);
                }
            });
            RuleSerializer.copyAll(elements, "E", this.allNames);
            RuleSerializer.copyAll(attributes, "A", this.allNames);
            RuleSerializer.copyAll(datatypes, "D", this.allNames);
            RuleSerializer.copyAll(classes, "C", this.allNames);
            RuleSerializer.copyAll(fields, "N", this.allNames);
            RuleSerializer.copyAll(primitives, "P", this.allNames);
            RuleSerializer.copyAll(ignores, "Ignore", this.allNames);
            ElementExp[] elms = elements.keySet().toArray(new ElementExp[0]);
            AttributeExp[] atts = attributes.keySet().toArray(new AttributeExp[0]);
            DataOrValueExp[] dts = datatypes.keySet().toArray(new DataOrValueExp[0]);
            ClassItem[] cis = classes.keySet().toArray(new ClassItem[0]);
            FieldItem[] fis = fields.keySet().toArray(new FieldItem[0]);
            PrimitiveItem[] pis = primitives.keySet().toArray(new PrimitiveItem[0]);
            IgnoreItem[] iis = ignores.keySet().toArray(new IgnoreItem[0]);
            for (i2 = 0; i2 < dts.length; ++i2) {
                out.start("dataSymbol", new String[]{"id", (String)this.allNames.get(dts[i2])});
                out.element("library", dts[i2].getName().namespaceURI);
                out.element("name", dts[i2].getName().localName);
                out.end("dataSymbol");
            }
            for (i2 = 0; i2 < cis.length; ++i2) {
                out.element("classSymbol", new String[]{"id", (String)this.allNames.get(cis[i2]), "type", cis[i2].getTypeName()});
            }
            for (i2 = 0; i2 < pis.length; ++i2) {
                out.element("primitiveSymbol", new String[]{"id", (String)this.allNames.get(pis[i2])});
            }
            for (i2 = 0; i2 < fis.length; ++i2) {
                out.element("namedSymbol", new String[]{"id", (String)this.allNames.get((Object)fis[i2])});
            }
            for (i2 = 0; i2 < iis.length; ++i2) {
                out.element("ignoreSymbol", new String[]{"id", (String)this.allNames.get((Object)iis[i2])});
            }
            int cnt = 1;
            Iterator itr = rules.iterateKeys();
            while (itr.hasNext()) {
                Expression symbol = (Expression)itr.next();
                if (this.allNames.containsKey(symbol)) continue;
                out.element("intermediateSymbol", new String[]{"id", "T" + cnt});
                this.allNames.put(symbol, "T" + cnt);
                ++cnt;
            }
            int rcounter = 0;
            itr = rules.iterateKeys();
            while (itr.hasNext()) {
                Expression nonTerminal = (Expression)itr.next();
                Rule[] rs = rules.getAll(nonTerminal);
                for (int j = 0; j < rs.length; ++j) {
                    if (this.allNames.get(rs[j]) != null) continue;
                    this.allNames.put(rs[j], Integer.toString(rcounter++));
                    rs[j].write(out, this);
                }
            }
            out.start("rulesList");
            Iterator itr2 = rules.iterateKeys();
            while (itr2.hasNext()) {
                Expression symbol = (Expression)itr2.next();
                out.start("nonTerminal", new String[]{"id", this.getId(symbol)});
                Rule[] rs = rules.getAll(symbol);
                for (int i3 = 0; i3 < rs.length; ++i3) {
                    out.element("rule", new String[]{"no", this.getId(rs[i3])});
                }
                out.end("nonTerminal");
            }
            out.end("rulesList");
            ExpressionSerializer eser = new ExpressionSerializer(this, out);
            for (i = 0; i < atts.length; ++i) {
                atts[i].exp.visit(eser.sequencer);
                eser.assignId((Expression)atts[i]);
            }
            for (i = 0; i < elms.length; ++i) {
                elms[i].contentModel.visit(eser.sequencer);
            }
            grammar.getTopLevel().visit(eser.sequencer);
            TreeMap id2expr = new TreeMap();
            for (Expression exp : eser.sharedExps) {
                id2expr.put(eser.expr2id.get(exp), exp);
            }
            for (Integer n : id2expr.keySet()) {
                Expression exp = (Expression)id2expr.get(n);
                if (exp instanceof AttributeExp) {
                    AttributeExp aexp = (AttributeExp)exp;
                    out.start("attributeSymbol", new String[]{"id", (String)this.allNames.get(aexp)});
                    ExpressionSerializer.serializeNameClass(aexp.getNameClass(), out);
                    out.start("content");
                    aexp.visit(eser.serializer);
                    out.end("content");
                    LLTableCalculator.calc((Expression)aexp, rules, grammar.getPool(), this).write(out, this);
                    out.end("attributeSymbol");
                    continue;
                }
                out.start("particle", new String[]{"id", "o" + n});
                exp.visit(eser.serializer);
                out.end("particle");
            }
            for (int i4 = 0; i4 < elms.length; ++i4) {
                out.start("elementSymbol", new String[]{"id", (String)this.allNames.get(elms[i4])});
                ExpressionSerializer.serializeNameClass(elms[i4].getNameClass(), out);
                out.start("content");
                elms[i4].visit(eser.serializer);
                out.end("content");
                LLTableCalculator.calc((Expression)elms[i4], rules, grammar.getPool(), this).write(out, this);
                out.end("elementSymbol");
            }
            if (elements.containsKey(grammar.getTopLevel())) {
                out.start("topLevel");
                out.start("content");
                eser.serialize(grammar.getTopLevel());
                out.end("content");
                out.end("topLevel");
            } else {
                out.start("topLevel", new String[]{"id", this.getId(grammar.getTopLevel())});
                out.start("content");
                grammar.getTopLevel().visit(eser.serializer);
                out.end("content");
                LLTableCalculator.calc(grammar.getTopLevel(), rules, grammar.getPool(), this).write(out, this);
                out.end("topLevel");
            }
            final HashSet rootClasses = new HashSet();
            grammar.getTopLevel().visit((ExpressionVisitorVoid)new ExpressionWalker(){
                private Set visitedExps = new HashSet();

                public void onOther(OtherExp exp) {
                    if (exp instanceof TypeItem) {
                        rootClasses.add(exp);
                    }
                }

                public void onElement(ElementExp exp) {
                    if (this.visitedExps.add(exp)) {
                        exp.contentModel.visit((ExpressionVisitorVoid)this);
                    }
                }
            });
            Type rootType = TypeUtil.getCommonBaseType(rootClasses);
            out.element("rootType", new String[]{"name", rootType.getTypeName()});
            out.end("grammar");
            outHandler.endDocument();
        }
        catch (XMLWriter.SAXWrapper w) {
            throw w.e;
        }
    }

    private static void copyAll(Map src, String prefix, Map dst) {
        for (Object symbol : src.keySet()) {
            dst.put(symbol, prefix + src.get(symbol));
        }
    }

    private static String computeName(NameClass nc, Map m) {
        if (nc instanceof SimpleNameClass) {
            SimpleNameClass snc = (SimpleNameClass)nc;
            String name = NameUtil.toIdentifier(snc.localName);
            if (!m.containsValue(name)) {
                return name;
            }
            return RuleSerializer.getNumberedName(snc.localName, 2, m);
        }
        return RuleSerializer.getNumberedName("", 1, m);
    }

    private static String getNumberedName(String prefix, int count, Map m) {
        String name;
        if (NameUtil.toIdentifier(prefix).length() == 0) {
            prefix = "_" + prefix;
        }
        while (m.containsValue(name = NameUtil.toIdentifier(prefix + Integer.toString(count++)))) {
        }
        return name;
    }

    private static String computeName(Datatype dt, Map m) {
        if (dt instanceof XSDatatype) {
            XSDatatype xsdt = (XSDatatype)dt;
            if (xsdt.getName() != null) {
                String name = NameUtil.toIdentifier(xsdt.getName());
                if (!m.containsValue(name)) {
                    return name;
                }
                RuleSerializer.getNumberedName(name, 2, m);
            } else {
                return RuleSerializer.getNumberedName(xsdt.displayName(), 2, m);
            }
        }
        return RuleSerializer.getNumberedName("", 0, m);
    }

    private static String computeName(ClassItem cls, Map m) {
        String name = cls.getBareName();
        if (!m.containsValue(name)) {
            return name;
        }
        return RuleSerializer.getNumberedName(name, 2, m);
    }

    private static String computeName(PrimitiveItem pitm, Map m) {
        String name = pitm.type.getBareName();
        if (!m.containsValue(name)) {
            return name;
        }
        return RuleSerializer.getNumberedName(name, 2, m);
    }

    private static String computeName(FieldItem field, Map m) {
        if (!m.containsValue(field.name)) {
            return field.name;
        }
        return RuleSerializer.getNumberedName(field.name, 2, m);
    }

    private static String computeName(IgnoreItem iim, Map m) {
        return RuleSerializer.getNumberedName("", 1, m);
    }

    private static String javaStringEscape(String s) {
        return "\"" + s + "\"";
    }
}

