/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.grammar.Expression;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.ll.FilterCalculator;
import java.util.Iterator;

public final class Rule {
    public Expression[] right;
    public boolean isInterleave;

    public Rule(Expression[] right, boolean isInterleave) {
        this.right = right;
        this.isInterleave = isInterleave;
        assert (right != null);
        for (int i = 0; i < right.length; ++i) {
            assert (right[i] != null);
        }
    }

    public Rule copy() {
        Expression[] r = new Expression[this.right.length];
        System.arraycopy(this.right, 0, r, 0, this.right.length);
        return new Rule(r, this.isInterleave);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule rhs = (Rule)o;
        if (this.right.length != rhs.right.length) {
            return false;
        }
        for (int i = 0; i < this.right.length; ++i) {
            if (this.right[i] == rhs.right[i]) continue;
            return false;
        }
        return this.isInterleave == rhs.isInterleave;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.right.length; ++i) {
            hashCode ^= this.right[i].hashCode();
        }
        return hashCode;
    }

    public boolean isEpsilonReducible() {
        for (int i = 0; i < this.right.length; ++i) {
            if (this.right[i].isEpsilonReducible()) continue;
            return false;
        }
        return true;
    }

    public boolean replaceRight(int idx, Rule replace) {
        Expression[] seq;
        boolean interleave;
        if (replace.right.length == 1) {
            interleave = this.isInterleave;
        } else if (this.right.length == 1) {
            interleave = replace.isInterleave;
        } else {
            if (this.isInterleave != replace.isInterleave) {
                return false;
            }
            interleave = this.isInterleave;
        }
        int rlen = replace.right.length;
        if (rlen == 1 && replace.right[0] == Expression.epsilon) {
            rlen = 0;
        }
        if ((seq = new Expression[this.right.length + rlen - 1]).length == 0) {
            seq = new Expression[]{Expression.epsilon};
        } else {
            System.arraycopy(this.right, 0, seq, 0, idx);
            System.arraycopy(replace.right, 0, seq, idx, rlen);
            System.arraycopy(this.right, idx + 1, seq, idx + rlen, this.right.length - (idx + 1));
        }
        this.right = seq;
        this.isInterleave = interleave;
        return true;
    }

    public String toString(Symbolizer symbolizr) {
        StringBuffer buf = new StringBuffer();
        buf.append(" --> ");
        if (this.isInterleave) {
            buf.append("(interleave) ");
        }
        for (int i = 0; i < this.right.length; ++i) {
            if (i != 0) {
                buf.append(' ');
            }
            buf.append(symbolizr.getId(this.right[i]));
        }
        return buf.toString();
    }

    public void write(XMLWriter writer, Symbolizer symbolizer) {
        writer.start("rule", new String[]{"interleave", this.isInterleave ? "true" : "false", "no", symbolizer.getId(this)});
        writer.start("right");
        for (int i = 0; i < this.right.length; ++i) {
            if (this.right[i] == Expression.epsilon) continue;
            writer.start("item", new String[]{"symbolRef", symbolizer.getId(this.right[i])});
            if (this.isInterleave && i != 0) {
                writer.start("filter");
                Iterator itr = FilterCalculator.calc(this.right[i]).iterator();
                while (itr.hasNext()) {
                    writer.element("item", new String[]{"symbolRef", symbolizer.getId(itr.next())});
                }
                writer.end("filter");
            }
            writer.end("item");
        }
        writer.end("right");
        writer.end("rule");
    }
}

