/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.ll;

import com.sun.msv.grammar.Expression;
import com.sun.tahiti.compiler.Symbolizer;
import com.sun.tahiti.compiler.XMLWriter;
import com.sun.tahiti.compiler.ll.Rule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ParserTable {
    private final Map impl = new HashMap();

    public void addRule(Expression nonTerminal, Expression terminal, Rule rule) {
        Set s = this.getOrCreateRuleSet(nonTerminal, terminal);
        s.add(rule);
    }

    public void addRules(Expression nonTerminal, Set terminals, Rule rule) {
        Iterator itr = terminals.iterator();
        while (itr.hasNext()) {
            this.getOrCreateRuleSet(nonTerminal, (Expression)itr.next()).add(rule);
        }
    }

    private Set getOrCreateRuleSet(Expression nonTerminal, Expression terminal) {
        HashSet s;
        HashMap m = (HashMap)this.impl.get(nonTerminal);
        if (m == null) {
            m = new HashMap();
            this.impl.put(nonTerminal, m);
        }
        if ((s = (HashSet)m.get(terminal)) == null) {
            s = new HashSet();
            m.put(terminal, s);
        }
        return s;
    }

    public void write(XMLWriter writer, Symbolizer symbolizer) {
        writer.start("parserTable");
        int no = 0;
        for (Expression nonTerm : this.impl.keySet()) {
            Map t2r = (Map)this.impl.get(nonTerm);
            writer.start("action", new String[]{"stackTop", symbolizer.getId(nonTerm)});
            Rule defaultAction = null;
            Set defaultActionSet = (Set)t2r.get(Expression.epsilon);
            if (defaultActionSet != null) {
                if (defaultActionSet.size() > 1) {
                    throw new Error();
                }
                if (defaultActionSet.size() == 1) {
                    defaultAction = (Rule)defaultActionSet.toArray()[0];
                }
            }
            for (Expression term : t2r.keySet()) {
                Rule[] rules = ((Set)t2r.get(term)).toArray(new Rule[0]);
                if (rules.length == 1 && rules[0] == defaultAction && term != Expression.epsilon) continue;
                if (term != Expression.epsilon) {
                    writer.start("token", new String[]{"id", symbolizer.getId(term), "no", Integer.toString(no++)});
                } else {
                    writer.start("otherwise");
                }
                for (int i = 0; i < rules.length; ++i) {
                    writer.element("rule", new String[]{"no", symbolizer.getId(rules[i])});
                }
                if (term != Expression.epsilon) {
                    writer.end("token");
                    continue;
                }
                writer.end("otherwise");
            }
            writer.end("action");
        }
        writer.end("parserTable");
    }
}

