/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.java;

import com.sun.tahiti.compiler.java.FieldSerializer;
import com.sun.tahiti.util.xml.DOMVisitor;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class MarshallerSerializer
extends DOMVisitor {
    private final Map fieldSerializers;
    private final PrintWriter out;
    private int indent = 2;

    public static void write(Map fieldSerializers, PrintWriter out, Document dom) {
        out.println("\tpublic void marshall( Marshaller out ) {");
        for (FieldSerializer fs : fieldSerializers.values()) {
            String s = fs.marshallerInitializer();
            if (s == null) continue;
            out.println("\t\t" + s);
        }
        new MarshallerSerializer(fieldSerializers, out).visit(dom);
        out.println("\t}");
        out.println("");
    }

    private MarshallerSerializer(Map fieldSerializers, PrintWriter out) {
        this.fieldSerializers = fieldSerializers;
        this.out = out;
    }

    private Iterator tokinizeString(String s) {
        final StringTokenizer tokens = new StringTokenizer(s);
        return new Iterator(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return tokens.hasMoreTokens();
            }

            public Object next() {
                return tokens.nextToken();
            }
        };
    }

    private String getConditionExp(String exp) {
        Iterator itr = this.tokinizeString(exp);
        boolean orNeeded = false;
        StringBuffer buf = new StringBuffer();
        while (itr.hasNext()) {
            if (orNeeded) {
                buf.append(" || ");
            }
            orNeeded = true;
            buf.append(this.getSerializer((String)itr.next()).hasMoreToken());
        }
        return buf.toString();
    }

    @Override
    public void visit(Element e) {
        String tagName = e.getTagName();
        if (tagName.equals("group")) {
            super.visit(e);
            return;
        }
        if (tagName.equals("oneOrMore")) {
            String exp = e.getAttribute("while");
            this.println("do {");
            ++this.indent;
            super.visit(e);
            --this.indent;
            this.println("} while( " + this.getConditionExp(exp) + " );");
            return;
        }
        if (tagName.equals("choice")) {
            super.visit(e);
            return;
        }
        if (tagName.equals("option")) {
            String exp = e.getAttribute("if");
            this.println("if( " + this.getConditionExp(exp) + " ) {");
            ++this.indent;
            super.visit(e);
            --this.indent;
            this.println("} else");
            return;
        }
        if (tagName.equals("otherwise")) {
            this.println("{");
            ++this.indent;
            super.visit(e);
            --this.indent;
            this.println("}");
            return;
        }
        if (tagName.equals("epsilon")) {
            this.println(";");
            return;
        }
        if (tagName.equals("notPossible")) {
            this.println("// assertion failed.");
            this.println("throw new Error();");
            return;
        }
        if (tagName.equals("marshall")) {
            String exp = e.getAttribute("fieldName");
            this.println(this.getSerializer(exp).marshall(e));
            return;
        }
        if (tagName.equals("element") || tagName.equals("attribute")) {
            String uri = e.getAttribute("uri");
            String local = e.getAttribute("name");
            String methodName = tagName.equals("element") ? "Element" : "Attribute";
            this.println("out.start" + methodName + "(" + MarshallerSerializer.quote(uri) + "," + MarshallerSerializer.quote(local) + ");");
            super.visit(e);
            this.println("out.end" + methodName + "(" + MarshallerSerializer.quote(uri) + "," + MarshallerSerializer.quote(local) + ");");
            return;
        }
        throw new Error("unknown tag name:" + tagName);
    }

    private static String quote(String body) {
        return "\"" + body + "\"";
    }

    private FieldSerializer getSerializer(String fieldName) {
        FieldSerializer s = (FieldSerializer)this.fieldSerializers.get(fieldName);
        if (s == null) {
            throw new Error(fieldName);
        }
        return s;
    }

    private void println(String s) {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print('\t');
        }
        this.out.println(s);
    }
}

