/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tahiti.compiler.java;

import com.sun.tahiti.compiler.java.AtmostOneFieldSerializer;
import com.sun.tahiti.compiler.java.ClassSerializer;
import com.sun.tahiti.compiler.java.ListFieldSerializer;
import com.sun.tahiti.compiler.java.PrimitiveTypeFieldSerializer;
import com.sun.tahiti.compiler.java.SetFieldSerializer;
import com.sun.tahiti.compiler.java.VectorFieldSerializer;
import com.sun.tahiti.grammar.AccessModifier;
import com.sun.tahiti.grammar.Accessor;
import com.sun.tahiti.grammar.CollectionType;
import com.sun.tahiti.grammar.FieldUse;
import com.sun.tahiti.reader.NameUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

abstract class FieldSerializer {
    protected final FieldUse fu;
    protected final ClassSerializer parent;
    protected final String capitalizedFieldName;
    protected static final Map boxTypes = new HashMap();

    public static FieldSerializer get(ClassSerializer parent, FieldUse fu) {
        if (fu.multiplicity.isUnique() && boxTypes.containsKey(fu.type.getTypeName())) {
            return new PrimitiveTypeFieldSerializer(parent, fu);
        }
        if (fu.multiplicity.isAtMostOnce()) {
            return new AtmostOneFieldSerializer(parent, fu);
        }
        CollectionType t = fu.getCollectionType();
        if (t == CollectionType.list) {
            return new ListFieldSerializer(parent, fu);
        }
        if (t == CollectionType.set) {
            return new SetFieldSerializer(parent, fu);
        }
        if (t == CollectionType.vector) {
            return new VectorFieldSerializer(parent, fu);
        }
        throw new Error("unrecognized collection type:" + t);
    }

    public FieldSerializer(ClassSerializer parent, FieldUse fu) {
        this.fu = fu;
        this.parent = parent;
        this.capitalizedFieldName = NameUtil.xmlNameToJavaName("class", fu.name);
    }

    abstract String getTypeStr();

    abstract String setField(String var1);

    final void writeFieldDef(PrintWriter out) {
        Accessor acc = this.fu.getAccessor();
        AccessModifier mod = this.fu.getAccessModifier();
        if (acc == Accessor.field) {
            this.writeVariableDef(out, mod);
        } else {
            this.writeVariableDef(out, AccessModifier._private);
        }
        if (acc != Accessor.field) {
            this.writeGetterDef(out, mod);
            if (acc == Accessor.readWrite) {
                this.writeSetterDef(out, mod);
            }
        }
    }

    abstract void writeVariableDef(PrintWriter var1, AccessModifier var2);

    abstract void writeGetterDef(PrintWriter var1, AccessModifier var2);

    abstract void writeSetterDef(PrintWriter var1, AccessModifier var2);

    abstract String marshallerInitializer();

    abstract String hasMoreToken();

    abstract String marshall(Element var1);

    protected static String format(String fmt, Object[] args) {
        return MessageFormat.format(fmt, args);
    }

    protected static String format(String fmt, Object arg1) {
        return MessageFormat.format(fmt, arg1);
    }

    protected static String format(String fmt, Object arg1, Object arg2) {
        return MessageFormat.format(fmt, arg1, arg2);
    }

    protected static String format(String fmt, Object arg1, Object arg2, Object arg3) {
        return MessageFormat.format(fmt, arg1, arg2, arg3);
    }

    protected static String format(String fmt, Object arg1, Object arg2, Object arg3, Object arg4) {
        return MessageFormat.format(fmt, arg1, arg2, arg3, arg4);
    }

    static {
        boxTypes.put("java.lang.Integer", "int");
        boxTypes.put("java.lang.Boolean", "boolean");
        boxTypes.put("java.lang.Double", "double");
        boxTypes.put("java.lang.Float", "float");
        boxTypes.put("java.lang.Char", "char");
        boxTypes.put("java.lang.Long", "long");
        boxTypes.put("java.lang.Byte", "byte");
        boxTypes.put("java.lang.Short", "short");
    }
}

