/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import java.time.Month;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_ACT_ISDA
extends DayCountConvention_ACT {
    private final boolean isCountLastDayNotFirst;

    public DayCountConvention_ACT_ACT_ISDA(boolean isCountFirstDayNotLast) {
        this.isCountLastDayNotFirst = isCountFirstDayNotLast;
    }

    public DayCountConvention_ACT_ACT_ISDA() {
        this(false);
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        double daycountFraction = (double)(endDate.getYear() - startDate.getYear()) - 1.0;
        LocalDate startDateNextYear = LocalDate.of(startDate.getYear() + 1, Month.JANUARY, 1);
        if (this.isCountLastDayNotFirst) {
            startDateNextYear = startDateNextYear.minusDays(1L);
        }
        daycountFraction += this.getDaycount(startDate, startDateNextYear) / (double)startDate.lengthOfYear();
        LocalDate endDateStartYear = LocalDate.of(endDate.getYear(), Month.JANUARY, 1);
        if (this.isCountLastDayNotFirst) {
            endDateStartYear = endDateStartYear.minusDays(1L);
        }
        return Math.max(daycountFraction += this.getDaycount(endDateStartYear, endDate) / (double)endDate.lengthOfYear(), 0.0);
    }

    public String toString() {
        return "DayCountConvention_ACT_ACT_ISDA [isCountLastDayNotFirst=" + this.isCountLastDayNotFirst + "]";
    }
}

