/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.IsoChronology;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_365A
extends DayCountConvention_ACT {
    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        LocalDate leapDayEnd;
        LocalDate leapDayStart;
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        double daysPerYear = 365.0;
        if (startDate.isLeapYear() && startDate.isBefore(leapDayStart = LocalDate.of(startDate.getYear(), Month.FEBRUARY, 29)) && !endDate.isBefore(leapDayStart)) {
            daysPerYear = 366.0;
        }
        if (endDate.isLeapYear() && startDate.isBefore(leapDayEnd = LocalDate.of(endDate.getYear(), Month.FEBRUARY, 29)) && !endDate.isBefore(leapDayEnd)) {
            daysPerYear = 366.0;
        }
        for (int year = startDate.getYear() + 1; year < endDate.getYear(); ++year) {
            if (!IsoChronology.INSTANCE.isLeapYear(year)) continue;
            daysPerYear = 366.0;
        }
        double daycountFraction = this.getDaycount(startDate, endDate) / daysPerYear;
        return daycountFraction;
    }
}

