/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import java.time.Month;
import net.finmath.time.daycount.DayCountConventionInterface;

public class DayCountConvention_30E_360_ISDA
implements DayCountConventionInterface {
    private final boolean isTreatEndDateAsTerminationDate;

    public DayCountConvention_30E_360_ISDA(boolean isTreatEndDateAsTerminationDate) {
        this.isTreatEndDateAsTerminationDate = isTreatEndDateAsTerminationDate;
    }

    public DayCountConvention_30E_360_ISDA() {
        this(false);
    }

    @Override
    public double getDaycount(LocalDate startDate, LocalDate endDate) {
        boolean isEndDateLastDayOfFebruary;
        if (startDate.isAfter(endDate)) {
            return -this.getDaycount(endDate, startDate);
        }
        int startDateDay = startDate.getDayOfMonth();
        int startDateMonth = startDate.getMonthValue();
        int startDateYear = startDate.getYear();
        int endDateDay = endDate.getDayOfMonth();
        int endDateMonth = endDate.getMonthValue();
        int endDateYear = endDate.getYear();
        boolean isStartDateLastDayOfFebruary = startDateMonth == Month.FEBRUARY.getValue() && startDateDay == startDate.lengthOfMonth();
        boolean bl = isEndDateLastDayOfFebruary = endDateMonth == Month.FEBRUARY.getValue() && endDateDay == endDate.lengthOfMonth();
        if (isStartDateLastDayOfFebruary || startDateDay == 31) {
            startDateDay = 30;
        }
        if (isEndDateLastDayOfFebruary && !this.isTreatEndDateAsTerminationDate || endDateDay == 31) {
            endDateDay = 30;
        }
        return (double)(endDateYear - startDateYear) * 360.0 + (double)(endDateMonth - startDateMonth) * 30.0 + ((double)endDateDay - Math.min((double)startDateDay, 30.0));
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        return this.getDaycount(startDate, endDate) / 360.0;
    }
}

