/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.time.LocalDate;
import net.finmath.time.daycount.DayCountConventionInterface;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import net.finmath.time.daycount.DayCountConvention_30U_360;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_YEARFRAC;

public class DayCountConventionFactory {
    public static DayCountConventionInterface getDayCountConvention(String convention) {
        if (convention.compareToIgnoreCase("act/act isda") == 0) {
            return new DayCountConvention_ACT_ACT_ISDA();
        }
        if (convention.compareToIgnoreCase("30/360") == 0) {
            return new DayCountConvention_30E_360_ISDA();
        }
        if (convention.compareToIgnoreCase("30e/360") == 0) {
            return new DayCountConvention_30E_360();
        }
        if (convention.compareToIgnoreCase("30u/360") == 0) {
            return new DayCountConvention_30U_360();
        }
        if (convention.compareToIgnoreCase("act/360") == 0) {
            return new DayCountConvention_ACT_360();
        }
        if (convention.compareToIgnoreCase("act/365") == 0) {
            return new DayCountConvention_ACT_365();
        }
        if (convention.compareToIgnoreCase("act/act yearfrac") == 0) {
            return new DayCountConvention_ACT_ACT_YEARFRAC();
        }
        throw new IllegalArgumentException("Unknow day count convention: " + convention);
    }

    public static double getDaycount(LocalDate startDate, LocalDate endDate, String convention) {
        DayCountConventionInterface daycountConvention = DayCountConventionFactory.getDayCountConvention(convention);
        return daycountConvention.getDaycount(startDate, endDate);
    }

    public static double getDaycountFraction(LocalDate startDate, LocalDate endDate, String convention) {
        DayCountConventionInterface daycountConvention = DayCountConventionFactory.getDayCountConvention(convention);
        return daycountConvention.getDaycountFraction(startDate, endDate);
    }
}

