/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.LocalDate;
import java.util.StringTokenizer;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public abstract class BusinessdayCalendar
implements BusinessdayCalendarInterface {
    @Override
    public LocalDate getAdjustedDate(LocalDate date, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.UNADJUSTED) {
            return date;
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.MODIFIED_FOLLOWING) {
            LocalDate adjustedDate = this.getAdjustedDate(date, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING);
            if (adjustedDate.getMonth() != date.getMonth()) {
                return this.getAdjustedDate(date, BusinessdayCalendarInterface.DateRollConvention.PRECEDING);
            }
            return adjustedDate;
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.MODIFIED_PRECEDING) {
            LocalDate adjustedDate = this.getAdjustedDate(date, BusinessdayCalendarInterface.DateRollConvention.PRECEDING);
            if (adjustedDate.getMonth() != date.getMonth()) {
                return this.getAdjustedDate(date, BusinessdayCalendarInterface.DateRollConvention.FOLLOWING);
            }
            return adjustedDate;
        }
        if (dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.FOLLOWING || dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.PRECEDING) {
            int adjustment = dateRollConvention == BusinessdayCalendarInterface.DateRollConvention.FOLLOWING ? 1 : -1;
            LocalDate adjustedDate = date;
            while (!this.isBusinessday(adjustedDate)) {
                adjustedDate = adjustedDate.plusDays(adjustment);
            }
            return adjustedDate;
        }
        throw new IllegalArgumentException("Unknown date roll convention.");
    }

    @Override
    public LocalDate getRolledDate(LocalDate baseDate, int businessDays) {
        BusinessdayCalendarInterface.DateRollConvention dateRollConvention;
        LocalDate rolledDate = baseDate;
        int direction = businessDays >= 0 ? 1 : -1;
        BusinessdayCalendarInterface.DateRollConvention dateRollConvention2 = dateRollConvention = direction > 0 ? BusinessdayCalendarInterface.DateRollConvention.FOLLOWING : BusinessdayCalendarInterface.DateRollConvention.PRECEDING;
        while (businessDays != 0) {
            rolledDate = rolledDate.plusDays(direction);
            rolledDate = this.getAdjustedDate(rolledDate, dateRollConvention);
            businessDays -= direction;
        }
        return rolledDate;
    }

    @Override
    public LocalDate getAdjustedDate(LocalDate baseDate, String dateOffsetCode, BusinessdayCalendarInterface.DateRollConvention dateRollConvention) {
        return this.getAdjustedDate(this.createDateFromDateAndOffsetCode(baseDate, dateOffsetCode), dateRollConvention);
    }

    @Override
    public LocalDate createDateFromDateAndOffsetCode(LocalDate baseDate, String dateOffsetCode) {
        dateOffsetCode = dateOffsetCode.trim();
        StringTokenizer tokenizer = new StringTokenizer(dateOffsetCode);
        LocalDate maturityDate = baseDate;
        while (tokenizer.hasMoreTokens()) {
            String maturityCodeSingle = tokenizer.nextToken();
            String[] maturityCodeSingleParts = maturityCodeSingle.split("(?<=[0-9|\\.])(?=[A-Z|a-z])");
            if (maturityCodeSingleParts.length == 1) {
                double maturityValue = Double.valueOf(maturityCodeSingle);
                maturityDate = maturityDate.plusDays((int)Math.round(maturityValue * 365.0));
                continue;
            }
            if (maturityCodeSingleParts.length == 2) {
                int maturityValue = Integer.valueOf(maturityCodeSingleParts[0]);
                BusinessdayCalendarInterface.DateOffsetUnit dateOffsetUnit = BusinessdayCalendarInterface.DateOffsetUnit.getEnum(maturityCodeSingleParts[1]);
                switch (dateOffsetUnit) {
                    case DAYS: {
                        maturityDate = maturityDate.plusDays(maturityValue);
                        break;
                    }
                    case BUSINESS_DAYS: {
                        maturityDate = this.getRolledDate(maturityDate, maturityValue);
                        break;
                    }
                    case WEEKS: {
                        maturityDate = maturityDate.plusWeeks(maturityValue);
                        break;
                    }
                    case MONTHS: {
                        maturityDate = maturityDate.plusMonths(maturityValue);
                        break;
                    }
                    case YEARS: {
                        maturityDate = maturityDate.plusYears(maturityValue);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
        }
        return maturityDate;
    }

    public String toString() {
        return "BusinessdayCalendar";
    }
}

