/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimplePointChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class OptimizerFactoryCMAES
implements OptimizerFactoryInterface {
    private final double accuracy;
    private final int maxIterations;
    private final double[] parameterLowerBound;
    private final double[] parameterUppderBound;
    private final double[] parameterStandardDeviation;

    public OptimizerFactoryCMAES(double accuracy, int maxIterations, double[] parameterLowerBound, double[] parameterUppderBound, double[] parameterStandardDeviation) {
        this.accuracy = accuracy;
        this.maxIterations = maxIterations;
        this.parameterLowerBound = parameterLowerBound;
        this.parameterUppderBound = parameterUppderBound;
        this.parameterStandardDeviation = parameterStandardDeviation;
    }

    public OptimizerFactoryCMAES(double accuracy, int maxIterations, double[] parameterStandardDeviation) {
        this.accuracy = accuracy;
        this.maxIterations = maxIterations;
        this.parameterLowerBound = null;
        this.parameterUppderBound = null;
        this.parameterStandardDeviation = parameterStandardDeviation;
    }

    public OptimizerFactoryCMAES(double accuracy, int maxIterations) {
        this.accuracy = accuracy;
        this.maxIterations = maxIterations;
        this.parameterLowerBound = null;
        this.parameterUppderBound = null;
        this.parameterStandardDeviation = null;
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, null, null, null, targetValues);
    }

    @Override
    public OptimizerInterface getOptimizer(OptimizerInterface.ObjectiveFunction objectiveFunction, double[] initialParameters, double[] lowerBound, double[] upperBound, double[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, null, targetValues);
    }

    @Override
    public OptimizerInterface getOptimizer(final OptimizerInterface.ObjectiveFunction objectiveFunction, final double[] initialParameters, double[] lowerBound, double[] upperBound, double[] parameterStep, double[] targetValues) {
        final double[] values = new double[targetValues.length];
        final double[] effectiveParameterLowerBound = this.parameterLowerBound != null ? this.parameterLowerBound : lowerBound;
        final double[] effectiveParameterUpperBound = this.parameterUppderBound != null ? this.parameterUppderBound : upperBound;
        final double[] effectiveParameterStandardDeviation = this.parameterStandardDeviation != null ? this.parameterStandardDeviation : parameterStep;
        return new OptimizerInterface(){
            private CMAESOptimizer optimizer;
            private PointValuePair result;

            @Override
            public double[] getBestFitParameters() {
                return this.result.getPoint();
            }

            @Override
            public double getRootMeanSquaredError() {
                return (Double)this.result.getValue();
            }

            @Override
            public int getIterations() {
                return this.optimizer != null ? this.optimizer.getIterations() : 0;
            }

            @Override
            public void run() throws SolverException {
                this.optimizer = new CMAESOptimizer(OptimizerFactoryCMAES.this.maxIterations, OptimizerFactoryCMAES.this.accuracy, true, 0, 0, (RandomGenerator)new MersenneTwister(3141), false, (ConvergenceChecker)new SimplePointChecker(0.0, 0.0)){

                    public double computeObjectiveValue(double[] parameters) {
                        try {
                            objectiveFunction.setValues(parameters, values);
                        }
                        catch (SolverException e) {
                            return Double.NaN;
                        }
                        double rms = 0.0;
                        for (double value : values) {
                            rms += value * value;
                        }
                        return Math.sqrt(rms);
                    }

                    public GoalType getGoalType() {
                        return GoalType.MINIMIZE;
                    }

                    public double[] getStartPoint() {
                        return initialParameters;
                    }

                    public double[] getLowerBound() {
                        return effectiveParameterLowerBound;
                    }

                    public double[] getUpperBound() {
                        return effectiveParameterUpperBound;
                    }
                };
                try {
                    this.result = this.optimizer.optimize(new OptimizationData[]{new CMAESOptimizer.PopulationSize((int)(4.0 + 3.0 * Math.log(initialParameters.length))), new CMAESOptimizer.Sigma(effectiveParameterStandardDeviation)});
                }
                catch (MathIllegalStateException e) {
                    new SolverException(e);
                }
            }
        };
    }
}

