/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign;

import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class LogNormalProcess {
    private BrownianMotionInterface brownianMotion;
    private RandomVariableInterface[][] discreteProcess = null;
    private RandomVariableInterface[] discreteProcessWeights = null;
    private TimeDiscretizationInterface timeDiscretization;
    private int numberOfComponents;
    private int numberOfFactors;
    private int numberOfPaths;
    private Scheme scheme = Scheme.EULER;

    public LogNormalProcess(int numberOfComponents, BrownianMotionInterface brownianMotion) {
        this.timeDiscretization = brownianMotion.getTimeDiscretization();
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = brownianMotion.getNumberOfFactors();
        this.numberOfPaths = brownianMotion.getNumberOfPaths();
        this.brownianMotion = brownianMotion;
    }

    public LogNormalProcess(TimeDiscretizationInterface timeDiscretization, int numberOfComponents, int numberOfPaths) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = 1;
        this.numberOfPaths = numberOfPaths;
        this.brownianMotion = new BrownianMotion(timeDiscretization, this.numberOfFactors, numberOfPaths, 3141);
    }

    public LogNormalProcess(TimeDiscretizationInterface timeDiscretization, int numberOfComponents, int numberOfFactors, int numberOfPaths, int seed) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfComponents = numberOfComponents;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.brownianMotion = new BrownianMotion(timeDiscretization, numberOfFactors, numberOfPaths, seed);
    }

    public abstract RandomVariableInterface[] getInitialValue();

    public abstract RandomVariableInterface getDrift(int var1, int var2, RandomVariableInterface[] var3, RandomVariableInterface[] var4);

    public RandomVariableInterface[] getDrift(int timeIndex, RandomVariableInterface[] realizationAtTimeIndex, RandomVariableInterface[] realizationPredictor) {
        RandomVariableInterface[] drift = new RandomVariableInterface[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            drift[componentIndex] = this.getDrift(timeIndex, componentIndex, realizationAtTimeIndex, realizationPredictor);
        }
        return drift;
    }

    public abstract RandomVariableInterface getFactorLoading(int var1, int var2, int var3, RandomVariableInterface[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface[] getProcessValue(int timeIndex) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[timeIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface getProcessValue(int timeIndex, int componentIndex) {
        if (timeIndex == 0) {
            return this.getInitialValue()[componentIndex];
        }
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcess[timeIndex][componentIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) {
        LogNormalProcess logNormalProcess = this;
        synchronized (logNormalProcess) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[timeIndex];
    }

    private void doPrecalculateProcess() {
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        this.discreteProcess = new RandomVariableInterface[this.timeDiscretization.getNumberOfTimeSteps() + 1][this.numberOfComponents];
        this.discreteProcessWeights = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = new RandomVariable(0.0, 1.0 / (double)this.numberOfPaths);
        this.discreteProcess[0] = this.getInitialValue();
        for (int timeIndex = 1; timeIndex < this.timeDiscretization.getNumberOfTimeSteps() + 1; ++timeIndex) {
            RandomVariableInterface previouseRealization;
            double deltaT = this.timeDiscretization.getTime(timeIndex) - this.timeDiscretization.getTime(timeIndex - 1);
            RandomVariableInterface[] variance = new RandomVariableInterface[this.numberOfComponents];
            RandomVariableInterface[] diffusion = new RandomVariableInterface[this.numberOfComponents];
            for (int componentIndex = this.numberOfComponents - 1; componentIndex >= 0; --componentIndex) {
                RandomVariableInterface varianceOfComponent = new RandomVariable(this.getTime(timeIndex - 1), 0.0);
                RandomVariableInterface diffusionOfComponent = new RandomVariable(this.getTime(timeIndex - 1), 0.0);
                for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                    RandomVariableInterface factorLoading = this.getFactorLoading(timeIndex - 1, factor, componentIndex, null);
                    RandomVariableInterface brownianIncrement = this.brownianMotion.getBrownianIncrement(timeIndex - 1, factor);
                    varianceOfComponent = varianceOfComponent.addProduct(factorLoading, factorLoading);
                    diffusionOfComponent = diffusionOfComponent.addProduct(factorLoading, brownianIncrement);
                }
                variance[componentIndex] = varianceOfComponent;
                diffusion[componentIndex] = diffusionOfComponent;
            }
            RandomVariableInterface[] drift = this.scheme == Scheme.PREDICTOR_USING_LASTREALIZATION ? this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], this.discreteProcess[timeIndex]) : this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], null);
            for (int componentIndex = this.numberOfComponents - 1; componentIndex >= 0; --componentIndex) {
                RandomVariableInterface driftOfComponent = drift[componentIndex];
                RandomVariableInterface varianceOfComponent = variance[componentIndex];
                RandomVariableInterface diffusionOfComponent = diffusion[componentIndex];
                if (driftOfComponent == null) {
                    this.discreteProcess[timeIndex][componentIndex] = this.discreteProcess[timeIndex - 1][componentIndex];
                    continue;
                }
                double[] newRealization = new double[this.numberOfPaths];
                previouseRealization = this.discreteProcess[timeIndex - 1][componentIndex];
                for (int pathIndex = 0; pathIndex < this.numberOfPaths; ++pathIndex) {
                    double previousValue = previouseRealization.get(pathIndex);
                    double driftOnPath = driftOfComponent.get(pathIndex);
                    double varianceOnPath = varianceOfComponent.get(pathIndex);
                    double diffusionOnPath = diffusionOfComponent.get(pathIndex);
                    newRealization[pathIndex] = previousValue * Math.exp(driftOnPath * deltaT - 0.5 * varianceOnPath * deltaT + diffusionOnPath);
                }
                this.discreteProcess[timeIndex][componentIndex] = new RandomVariable(this.getTime(timeIndex), newRealization);
            }
            if (this.scheme == Scheme.PREDICTOR_USING_EULERSTEP) {
                RandomVariable[] newRealization = new RandomVariable[this.numberOfComponents];
                drift = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], this.discreteProcess[timeIndex]);
                for (int componentIndex = 0; componentIndex < this.numberOfComponents; ++componentIndex) {
                    RandomVariableInterface driftOfComponent = drift[componentIndex];
                    RandomVariableInterface varianceOfComponent = variance[componentIndex];
                    RandomVariableInterface diffusionOfComponent = diffusion[componentIndex];
                    previouseRealization = this.discreteProcess[timeIndex - 1][componentIndex];
                    newRealization[componentIndex] = previouseRealization.mult(driftOfComponent.mult(deltaT).sub(varianceOfComponent.mult(0.5 * deltaT)).add(diffusionOfComponent).exp());
                }
                this.discreteProcess[timeIndex] = newRealization;
            }
            this.discreteProcessWeights[timeIndex] = this.discreteProcessWeights[timeIndex - 1];
        }
    }

    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public double getTime(int timeIndex) {
        return this.timeDiscretization.getTime(timeIndex);
    }

    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    public BrownianMotionInterface getBrownianMotion() {
        return this.brownianMotion;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    protected synchronized void setBrownianMotion(BrownianMotionInterface brownianMotion) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.brownianMotion = brownianMotion;
    }

    public synchronized void setScheme(Scheme scheme) {
        if (this.discreteProcessWeights != null && this.discreteProcessWeights.length != 0) {
            throw new RuntimeException("Tying to change lazy initialized immutable object after initialization.");
        }
        this.scheme = scheme;
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_USING_EULERSTEP,
        PREDICTOR_USING_LASTREALIZATION;

    }
}

