/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.products;

import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationInterface;
import net.finmath.stochastic.RandomVariableInterface;

public class PortfolioMonteCarloProduct
extends AbstractMonteCarloProduct {
    private AbstractMonteCarloProduct[] products;
    private double[] weights;

    public PortfolioMonteCarloProduct(AbstractMonteCarloProduct[] products) {
        this(products, PortfolioMonteCarloProduct.weightsOfOne(products.length));
    }

    public PortfolioMonteCarloProduct(AbstractMonteCarloProduct[] products, double[] weights) {
        this.products = products;
        this.weights = weights;
    }

    private static double[] weightsOfOne(int length) {
        double[] weightsOfOne = new double[length];
        Arrays.fill(weightsOfOne, 1.0);
        return weightsOfOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getValue(final double evaluationTime, final MonteCarloSimulationInterface model) throws CalculationException {
        if (this.products == null || this.products.length == 0) {
            return null;
        }
        int numberOfThreads = Math.min(Math.max(2 * Runtime.getRuntime().availableProcessors(), 1), this.products.length);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        RandomVariableInterface value = null;
        try {
            int i;
            Vector values = new Vector(this.products.length);
            for (i = 0; i < this.products.length; ++i) {
                final AbstractMonteCarloProduct product = this.products[i];
                final double weight = this.weights[i];
                Callable<RandomVariableInterface> worker = new Callable<RandomVariableInterface>(){

                    @Override
                    public RandomVariableInterface call() throws CalculationException {
                        return product.getValue(evaluationTime, model).mult(weight);
                    }
                };
                executor.submit(worker);
            }
            value = (RandomVariableInterface)((Future)values.get(0)).get();
            for (i = 1; i < this.products.length; ++i) {
                value = value.add((RandomVariableInterface)((Future)values.get(i)).get());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            executor.shutdown();
        }
        return value;
    }
}

