/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.concurrency.FutureWrapper;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.IndependentIncrementsInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.optimizer.SolverException;
import net.finmath.stochastic.RandomVariableInterface;

public class ProcessEulerScheme
extends AbstractProcess {
    private static boolean isUseMultiThreadding = Boolean.parseBoolean(System.getProperty("net.finmath.montecarlo.process.ProcessEulerScheme.isUseMultiThreadding", "true"));
    private IndependentIncrementsInterface stochasticDriver;
    private Scheme scheme = Scheme.EULER;
    private ExecutorService executor;
    private transient RandomVariableInterface[][] discreteProcess = null;
    private transient RandomVariableInterface[] discreteProcessWeights;

    public ProcessEulerScheme(IndependentIncrementsInterface stochasticDriver, Scheme scheme) {
        super(stochasticDriver.getTimeDiscretization());
        this.stochasticDriver = stochasticDriver;
        this.scheme = scheme;
    }

    public ProcessEulerScheme(IndependentIncrementsInterface stochasticDriver) {
        super(stochasticDriver.getTimeDiscretization());
        this.stochasticDriver = stochasticDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getProcessValue(int timeIndex, int componentIndex) {
        ProcessEulerScheme processEulerScheme = this;
        synchronized (processEulerScheme) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        if (this.discreteProcess[timeIndex][componentIndex] == null) {
            throw new NullPointerException("Generation of process component " + componentIndex + " at time index " + timeIndex + " failed. Likely due to out of memory");
        }
        return this.discreteProcess[timeIndex][componentIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) {
        ProcessEulerScheme processEulerScheme = this;
        synchronized (processEulerScheme) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[timeIndex];
    }

    private void doPrecalculateProcess() {
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        int numberOfPaths = this.getNumberOfPaths();
        int numberOfFactors = this.getNumberOfFactors();
        int numberOfComponents = this.getNumberOfComponents();
        this.discreteProcess = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1][this.getNumberOfComponents()];
        this.discreteProcessWeights = new RandomVariableInterface[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = this.stochasticDriver.getRandomVariableForConstant(1.0 / (double)numberOfPaths);
        RandomVariableInterface[] initialState = this.getInitialState();
        final RandomVariableInterface[] currentState = new RandomVariableInterface[numberOfComponents];
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            currentState[componentIndex] = initialState[componentIndex];
            this.discreteProcess[0][componentIndex] = this.applyStateSpaceTransform(componentIndex, currentState[componentIndex]);
        }
        int numberOfThreads = Math.min(Math.max(2 * Runtime.getRuntime().availableProcessors(), 1), numberOfComponents);
        this.executor = Executors.newFixedThreadPool(numberOfThreads);
        for (int timeIndex2 = 1; timeIndex2 < this.getTimeDiscretization().getNumberOfTimeSteps() + 1; ++timeIndex2) {
            final int timeIndex = timeIndex2;
            final double deltaT = this.getTime(timeIndex) - this.getTime(timeIndex - 1);
            RandomVariableInterface[] drift = null;
            try {
                drift = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], null);
            }
            catch (Exception e) {
                throw new RuntimeException("Drift calculaton failed at time " + this.getTime(timeIndex - 1), e);
            }
            Vector<Future<RandomVariableInterface>> discreteProcessAtCurrentTimeIndex = new Vector<Future<RandomVariableInterface>>(numberOfComponents);
            discreteProcessAtCurrentTimeIndex.setSize(numberOfComponents);
            for (int componentIndex2 = 0; componentIndex2 < numberOfComponents; ++componentIndex2) {
                final int componentIndex = componentIndex2;
                final RandomVariableInterface driftOfComponent = drift[componentIndex];
                if (driftOfComponent == null) continue;
                Callable<RandomVariableInterface> worker = new Callable<RandomVariableInterface>(){

                    @Override
                    public RandomVariableInterface call() throws SolverException {
                        RandomVariableInterface[] factorLoadings;
                        if (ProcessEulerScheme.this.scheme == Scheme.EULER_FUNCTIONAL) {
                            currentState[componentIndex] = ProcessEulerScheme.this.applyStateSpaceTransformInverse(componentIndex, ProcessEulerScheme.this.discreteProcess[timeIndex - 1][componentIndex]);
                        }
                        if ((factorLoadings = ProcessEulerScheme.this.getFactorLoading(timeIndex - 1, componentIndex, ProcessEulerScheme.this.discreteProcess[timeIndex - 1])) == null) {
                            return null;
                        }
                        if (driftOfComponent != null) {
                            currentState[componentIndex] = currentState[componentIndex].addProduct(driftOfComponent, deltaT);
                        }
                        RandomVariableInterface[] brownianIncrement = ProcessEulerScheme.this.stochasticDriver.getIncrement(timeIndex - 1);
                        currentState[componentIndex] = currentState[componentIndex].addSumProduct(Arrays.asList(factorLoadings), Arrays.asList(brownianIncrement));
                        return ProcessEulerScheme.this.applyStateSpaceTransform(componentIndex, currentState[componentIndex]).cache();
                    }
                };
                Future<RandomVariableInterface> result = null;
                if (isUseMultiThreadding) {
                    result = this.executor.submit(worker);
                } else {
                    try {
                        result = new FutureWrapper<RandomVariableInterface>((RandomVariableInterface)worker.call());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                discreteProcessAtCurrentTimeIndex.set(componentIndex, result);
            }
            for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
                try {
                    Future discreteProcessAtCurrentTimeIndexAndComponent = (Future)discreteProcessAtCurrentTimeIndex.get(componentIndex);
                    if (discreteProcessAtCurrentTimeIndexAndComponent != null) {
                        this.discreteProcess[timeIndex][componentIndex] = ((RandomVariableInterface)discreteProcessAtCurrentTimeIndexAndComponent.get()).cache();
                        continue;
                    }
                    this.discreteProcess[timeIndex][componentIndex] = null;
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (this.scheme == Scheme.PREDICTOR_CORRECTOR) {
                RandomVariableInterface[] driftWithPredictor = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex], null);
                for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                    RandomVariableInterface driftWithPredictorOfComponent = driftWithPredictor[componentIndex];
                    RandomVariableInterface driftWithoutPredictorOfComponent = drift[componentIndex];
                    if (driftWithPredictorOfComponent == null || driftWithoutPredictorOfComponent == null) continue;
                    RandomVariableInterface driftAdjustment = driftWithPredictorOfComponent.sub(driftWithoutPredictorOfComponent).div(2.0).mult(deltaT);
                    currentState[componentIndex] = currentState[componentIndex].add(driftAdjustment);
                    this.discreteProcess[timeIndex][componentIndex] = this.applyStateSpaceTransform(componentIndex, currentState[componentIndex]);
                }
            }
            this.discreteProcessWeights[timeIndex] = this.discreteProcessWeights[timeIndex - 1];
        }
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private synchronized void reset() {
        this.discreteProcess = null;
        this.discreteProcessWeights = null;
    }

    @Override
    public int getNumberOfPaths() {
        return this.stochasticDriver.getNumberOfPaths();
    }

    @Override
    public int getNumberOfFactors() {
        return this.stochasticDriver.getNumberOfFactors();
    }

    @Override
    public IndependentIncrementsInterface getStochasticDriver() {
        return this.stochasticDriver;
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return (BrownianMotionInterface)this.stochasticDriver;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public ProcessEulerScheme clone() {
        return new ProcessEulerScheme(this.getStochasticDriver(), this.scheme);
    }

    @Override
    public AbstractProcessInterface getCloneWithModifiedData(Map<String, Object> dataModified) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        return new ProcessEulerScheme(this.getBrownianMotion().getCloneWithModifiedSeed(seed));
    }

    public String toString() {
        return "ProcessEulerScheme [stochasticDriver=" + this.stochasticDriver + ", scheme=" + (Object)((Object)this.scheme) + ", executor=" + this.executor + "]";
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_CORRECTOR,
        EULER_FUNCTIONAL;

    }
}

