/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.model;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public interface AbstractModelInterface {
    public TimeDiscretizationInterface getTimeDiscretization();

    public int getNumberOfComponents();

    public RandomVariableInterface applyStateSpaceTransform(int var1, RandomVariableInterface var2);

    public RandomVariableInterface applyStateSpaceTransformInverse(int var1, RandomVariableInterface var2);

    public RandomVariableInterface[] getInitialState();

    public RandomVariableInterface getNumeraire(double var1) throws CalculationException;

    public RandomVariableInterface[] getDrift(int var1, RandomVariableInterface[] var2, RandomVariableInterface[] var3);

    public int getNumberOfFactors();

    public RandomVariableInterface[] getFactorLoading(int var1, int var2, RandomVariableInterface[] var3);

    default public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    public void setProcess(AbstractProcessInterface var1);

    public AbstractProcessInterface getProcess();

    public AbstractModelInterface getCloneWithModifiedData(Map<String, Object> var1) throws CalculationException;
}

