/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.model;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public abstract class AbstractModel
implements AbstractModelInterface {
    private AbstractProcessInterface process;

    public RandomVariableInterface[] getInitialValue() {
        RandomVariableInterface[] initialState = this.getInitialState();
        RandomVariableInterface[] value = new RandomVariableInterface[initialState.length];
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.applyStateSpaceTransform(i, initialState[i]);
        }
        return value;
    }

    @Override
    public void setProcess(AbstractProcessInterface process) {
        this.process = process;
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.process;
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }

    public RandomVariableInterface getProcessValue(int timeIndex, int componentIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, componentIndex);
    }

    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public final TimeDiscretizationInterface getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    public final double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    public final int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }
}

