/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.util.HashSet;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariableInterface;

public class LIBORIndex
extends AbstractIndex {
    private static final long serialVersionUID = 1L;
    private final double periodStartOffset;
    private final double periodLength;

    public LIBORIndex(String name, double periodStartOffset, double periodLength) {
        super(name);
        this.periodStartOffset = periodStartOffset;
        this.periodLength = periodLength;
    }

    public LIBORIndex(double periodStartOffset, double periodLength) {
        this(null, periodStartOffset, periodLength);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        if (model.getModel().getForwardRateCurve().getName() != null && this.getName() != null && !model.getModel().getForwardRateCurve().getName().contains(this.getName())) {
            throw new IllegalArgumentException("No curve for index " + this.getName() + " found in model.");
        }
        RandomVariableInterface forwardRate = model.getLIBOR(evaluationTime, evaluationTime + this.periodStartOffset, evaluationTime + this.periodStartOffset + this.periodLength);
        return forwardRate;
    }

    public double getPeriodStartOffset() {
        return this.periodStartOffset;
    }

    public double getPeriodLength() {
        return this.periodLength;
    }

    @Override
    public Set<String> queryUnderlyings() {
        HashSet<String> underlyingNames = new HashSet<String>();
        underlyingNames.add(this.getName());
        return underlyingNames;
    }

    @Override
    public String toString() {
        return "LIBORIndex [periodStartOffset=" + this.periodStartOffset + ", periodLength=" + this.periodLength + ", toString()=" + super.toString() + "]";
    }
}

