/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.stochastic.RandomVariableInterface;

public class Cashflow
extends AbstractProductComponent {
    private static final long serialVersionUID = 2336470863786839896L;
    private final double flowAmount;
    private final double flowDate;
    private final boolean isPayer;

    public Cashflow(String currency, double flowAmount, double flowDate, boolean isPayer) {
        super(currency);
        this.flowAmount = flowAmount;
        this.flowDate = flowDate;
        this.isPayer = isPayer;
    }

    public Cashflow(double flowAmount, double flowDate, boolean isPayer) {
        this(null, flowAmount, flowDate, isPayer);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return null;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        if (evaluationTime > this.flowDate) {
            return model.getRandomVariableForConstant(0.0);
        }
        RandomVariableInterface values = model.getRandomVariableForConstant(this.flowAmount);
        if (this.isPayer) {
            values = values.mult(-1.0);
        }
        if (this.flowDate != evaluationTime) {
            RandomVariableInterface numeraire = model.getNumeraire(this.flowDate);
            RandomVariableInterface numeraireAtEval = model.getNumeraire(evaluationTime);
            values = values.div(numeraire).mult(numeraireAtEval);
        }
        return values;
    }

    @Override
    public String toString() {
        return "Cashflow [flowAmount=" + this.flowAmount + ", flowDate=" + this.flowDate + ", isPayer=" + this.isPayer + ", toString()=" + super.toString() + "]";
    }
}

