/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractPeriod;
import net.finmath.stochastic.RandomVariableInterface;

public class AccruingNotional
implements AbstractNotional {
    AbstractNotional previousPeriodNotional;
    AbstractPeriod previousPeriod;

    public AccruingNotional(AbstractNotional previousPeriodNotional, AbstractPeriod previousPeriod) {
        this.previousPeriodNotional = previousPeriodNotional;
        this.previousPeriod = previousPeriod;
    }

    @Override
    public String getCurrency() {
        return this.previousPeriodNotional.getCurrency();
    }

    @Override
    public RandomVariableInterface getNotionalAtPeriodStart(AbstractPeriod period, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        return this.previousPeriodNotional.getNotionalAtPeriodEnd(this.previousPeriod, model).mult(this.previousPeriod.getCoupon(model).add(1.0));
    }

    @Override
    public RandomVariableInterface getNotionalAtPeriodEnd(AbstractPeriod period, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        return this.getNotionalAtPeriodStart(period, model);
    }
}

