/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximation;
import net.finmath.montecarlo.interestrate.products.SwaptionAnalyticApproximationRebonato;
import net.finmath.montecarlo.interestrate.products.SwaptionSimple;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionFactory {
    public static AbstractLIBORMonteCarloProduct createSwaption(String className, double swaprate, TimeDiscretizationInterface swapTenor, String valueUnitAsString) {
        if (className.equals("SwaptionAnalyticApproximation")) {
            SwaptionAnalyticApproximation.ValueUnit valueUnit = SwaptionAnalyticApproximation.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionAnalyticApproximation(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        if (className.equals("SwaptionSimple")) {
            SwaptionSimple.ValueUnit valueUnit = SwaptionSimple.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionSimple(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        if (className.equals("SwaptionAnalyticApproximationRebonato")) {
            SwaptionAnalyticApproximationRebonato.ValueUnit valueUnit = SwaptionAnalyticApproximationRebonato.ValueUnit.valueOf(valueUnitAsString);
            return new SwaptionAnalyticApproximationRebonato(swaprate, swapTenor.getAsDoubleArray(), valueUnit);
        }
        throw new RuntimeException("Unknown class: " + className);
    }
}

