/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.LIBORMarketModelInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class SwaptionAnalyticApproximation
extends AbstractLIBORMonteCarloProduct {
    private final double swaprate;
    private final double[] swapTenor;
    private final ValueUnit valueUnit;
    private Map<String, double[]> cachedLogSwaprateDerivative;
    private WeakReference<TimeDiscretizationInterface> cachedLogSwaprateDerivativeTimeDiscretization;
    private WeakReference<DiscountCurveInterface> cachedLogSwaprateDerivativeDiscountCurve;
    private WeakReference<ForwardCurveInterface> cachedLogSwaprateDerivativeForwardCurve;
    private Object cachedLogSwaprateDerivativeLock = new Object();

    public SwaptionAnalyticApproximation(double swaprate, TimeDiscretizationInterface swapTenor) {
        this(swaprate, swapTenor.getAsDoubleArray(), ValueUnit.VALUE);
    }

    public SwaptionAnalyticApproximation(double swaprate, double[] swapTenor, ValueUnit valueUnit) {
        this.swaprate = swaprate;
        this.swapTenor = swapTenor;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) {
        TermStructureModelInterface modelBase = model.getModel();
        if (modelBase instanceof LIBORMarketModelInterface) {
            return this.getValues(evaluationTime, (LIBORMarketModelInterface)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModelInterface.");
    }

    public RandomVariableInterface getValues(double evaluationTime, LIBORMarketModelInterface model) {
        if (evaluationTime > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double swapStart = this.swapTenor[0];
        double swapEnd = this.swapTenor[this.swapTenor.length - 1];
        int swapStartIndex = model.getLiborPeriodIndex(swapStart);
        int swapEndIndex = model.getLiborPeriodIndex(swapEnd);
        int optionMaturityIndex = model.getCovarianceModel().getTimeDiscretization().getTimeIndex(swapStart) - 1;
        Map<String, double[]> logSwaprateDerivative = this.getLogSwaprateDerivative(model.getLiborPeriodDiscretization(), model.getDiscountCurve(), model.getForwardRateCurve());
        double[] swapCovarianceWeights = logSwaprateDerivative.get("values");
        double[][] integratedLIBORCovariance = model.getIntegratedLIBORCovariance()[optionMaturityIndex];
        double integratedSwapRateVariance = 0.0;
        for (int componentIndex1 = swapStartIndex; componentIndex1 < swapEndIndex; ++componentIndex1) {
            for (int componentIndex2 = componentIndex1 + 1; componentIndex2 < swapEndIndex; ++componentIndex2) {
                integratedSwapRateVariance += 2.0 * swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex2 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex2];
            }
            integratedSwapRateVariance += swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex1 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex1];
        }
        if (this.valueUnit == ValueUnit.INTEGRATEDVARIANCE) {
            return new RandomVariable(evaluationTime, integratedSwapRateVariance);
        }
        double volatility = Math.sqrt(integratedSwapRateVariance / swapStart);
        if (this.valueUnit == ValueUnit.VOLATILITY) {
            return new RandomVariable(evaluationTime, volatility);
        }
        double parSwaprate = Swap.getForwardSwapRate(new TimeDiscretization(this.swapTenor), new TimeDiscretization(this.swapTenor), model.getForwardRateCurve(), model.getDiscountCurve());
        double swapAnnuity = SwapAnnuity.getSwapAnnuity((TimeDiscretizationInterface)new TimeDiscretization(this.swapTenor), model.getDiscountCurve());
        double optionMaturity = swapStart;
        double valueSwaption = AnalyticFormulas.blackModelSwaptionValue(parSwaprate, volatility, optionMaturity, this.swaprate, swapAnnuity);
        return new RandomVariable(evaluationTime, valueSwaption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, double[]> getLogSwaprateDerivative(TimeDiscretizationInterface liborPeriodDiscretization, DiscountCurveInterface discountCurveInterface, ForwardCurveInterface forwardCurveInterface) {
        Object object = this.cachedLogSwaprateDerivativeLock;
        synchronized (object) {
            if (this.cachedLogSwaprateDerivative != null && liborPeriodDiscretization == this.cachedLogSwaprateDerivativeTimeDiscretization.get() && discountCurveInterface == this.cachedLogSwaprateDerivativeDiscountCurve.get() && forwardCurveInterface == this.cachedLogSwaprateDerivativeForwardCurve.get()) {
                return this.cachedLogSwaprateDerivative;
            }
            this.cachedLogSwaprateDerivativeTimeDiscretization = new WeakReference<TimeDiscretizationInterface>(liborPeriodDiscretization);
            this.cachedLogSwaprateDerivativeDiscountCurve = new WeakReference<DiscountCurveInterface>(discountCurveInterface);
            this.cachedLogSwaprateDerivativeForwardCurve = new WeakReference<ForwardCurveInterface>(forwardCurveInterface);
            AnalyticModel model = null;
            if (discountCurveInterface == null) {
                discountCurveInterface = new DiscountCurveFromForwardCurve(forwardCurveInterface.getName());
                model = new AnalyticModel(new CurveInterface[]{forwardCurveInterface, discountCurveInterface});
            }
            double swapStart = this.swapTenor[0];
            double swapEnd = this.swapTenor[this.swapTenor.length - 1];
            int swapStartIndex = liborPeriodDiscretization.getTimeIndex(swapStart);
            int swapEndIndex = liborPeriodDiscretization.getTimeIndex(swapEnd);
            double[] forwardRates = new double[swapEndIndex - swapStartIndex + 1];
            double[] discountFactors = new double[swapEndIndex - swapStartIndex + 1];
            discountFactors[0] = discountCurveInterface.getDiscountFactor(model, swapStart);
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                double libor;
                forwardRates[liborPeriodIndex - swapStartIndex] = libor = forwardCurveInterface.getForward(null, liborPeriodDiscretization.getTime(liborPeriodIndex));
                discountFactors[liborPeriodIndex - swapStartIndex + 1] = discountCurveInterface.getDiscountFactor(model, liborPeriodDiscretization.getTime(liborPeriodIndex + 1));
            }
            double[] swapAnnuities = new double[this.swapTenor.length - 1];
            double swapAnnuity = 0.0;
            for (int swapPeriodIndex = this.swapTenor.length - 2; swapPeriodIndex >= 0; --swapPeriodIndex) {
                int periodEndIndex = liborPeriodDiscretization.getTimeIndex(this.swapTenor[swapPeriodIndex + 1]);
                swapAnnuities[swapPeriodIndex] = swapAnnuity += discountFactors[periodEndIndex - swapStartIndex] * (this.swapTenor[swapPeriodIndex + 1] - this.swapTenor[swapPeriodIndex]);
            }
            double[] swapCovarianceWeights = new double[swapEndIndex - swapStartIndex];
            double valueFloatLeg = 0.0;
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                double liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
                valueFloatLeg += forwardRates[liborPeriodIndex - swapStartIndex] * discountFactors[liborPeriodIndex - swapStartIndex + 1] * liborPeriodLength;
            }
            int swapPeriodIndex = 0;
            double valueFloatLegUpToSwapStart = 0.0;
            for (int liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
                if (liborPeriodDiscretization.getTime(liborPeriodIndex) >= this.swapTenor[swapPeriodIndex + 1]) {
                    ++swapPeriodIndex;
                }
                double libor = forwardRates[liborPeriodIndex - swapStartIndex];
                double liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
                double discountFactorAtPeriodEnd = discountCurveInterface.getDiscountFactor(model, liborPeriodDiscretization.getTime(liborPeriodIndex + 1));
                double derivativeFloatLeg = (discountFactorAtPeriodEnd + (valueFloatLegUpToSwapStart += forwardRates[liborPeriodIndex - swapStartIndex] * discountFactors[liborPeriodIndex - swapStartIndex + 1] * liborPeriodLength) - valueFloatLeg) * liborPeriodLength / (1.0 + libor * liborPeriodLength) / valueFloatLeg;
                double derivativeFixLeg = -swapAnnuities[swapPeriodIndex] / swapAnnuity * liborPeriodLength / (1.0 + libor * liborPeriodLength);
                swapCovarianceWeights[liborPeriodIndex - swapStartIndex] = (derivativeFloatLeg - derivativeFixLeg) * libor;
            }
            HashMap<String, double[]> results = new HashMap<String, double[]>();
            results.put("values", swapCovarianceWeights);
            results.put("discountFactors", discountFactors);
            results.put("swapAnnuities", swapAnnuities);
            this.cachedLogSwaprateDerivative = results;
            return results;
        }
    }

    public static double[][][] getIntegratedLIBORCovariance(LIBORMarketModel model) {
        return model.getIntegratedLIBORCovariance();
    }

    public static enum ValueUnit {
        VALUE,
        INTEGRATEDVARIANCE,
        VOLATILITY;

    }
}

