/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractNotional;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.AccruingNotional;
import net.finmath.montecarlo.interestrate.products.components.Period;
import net.finmath.montecarlo.interestrate.products.components.ProductCollection;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.montecarlo.interestrate.products.indices.FixedCoupon;
import net.finmath.montecarlo.interestrate.products.indices.LinearCombinationIndex;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.ScheduleInterface;

public class SwapLeg
extends AbstractLIBORMonteCarloProduct {
    private final ScheduleInterface legSchedule;
    private final AbstractNotional notional;
    private final AbstractIndex index;
    private final double spread;
    private final boolean couponFlow;
    private final boolean isNotionalExchanged;
    private final boolean isNotionalAccruing;
    private final ProductCollection components;

    public SwapLeg(ScheduleInterface legSchedule, AbstractNotional notional, AbstractIndex index, double spread, boolean couponFlow, boolean isNotionalExchanged, boolean isNotionalAccruing) {
        this.legSchedule = legSchedule;
        this.notional = notional;
        this.index = index;
        this.spread = spread;
        this.couponFlow = couponFlow;
        this.isNotionalExchanged = isNotionalExchanged;
        this.isNotionalAccruing = isNotionalAccruing;
        ArrayList<AbstractProductComponent> periods = new ArrayList<AbstractProductComponent>();
        for (int periodIndex = 0; periodIndex < legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = legSchedule.getFixing(periodIndex);
            double paymentDate = legSchedule.getPayment(periodIndex);
            double periodLength = legSchedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            AbstractIndex coupon = index != null ? (spread != 0.0 ? new LinearCombinationIndex(1.0, index, 1.0, new FixedCoupon(spread)) : index) : new FixedCoupon(spread);
            Period period = new Period(fixingDate, paymentDate, fixingDate, paymentDate, notional, coupon, periodLength, couponFlow, isNotionalExchanged, false);
            periods.add(period);
            if (!isNotionalAccruing) continue;
            notional = new AccruingNotional(notional, period);
        }
        this.components = new ProductCollection(periods);
    }

    public SwapLeg(ScheduleInterface legSchedule, AbstractNotional notional, AbstractIndex index, double spread, boolean isNotionalExchanged) {
        this(legSchedule, notional, index, spread, true, isNotionalExchanged, false);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        return this.components.getValue(evaluationTime, model);
    }
}

