/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.products.AbstractLIBORMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class MoneyMarketAccount
extends AbstractLIBORMonteCarloProduct {
    private double inceptionTime = 0.0;
    private double initialValue = 1.0;
    private double accrualPeriod = -1.0;

    public MoneyMarketAccount(double inceptionTime, double initialValue, double accrualPeriod) {
        this.inceptionTime = inceptionTime;
        this.initialValue = initialValue;
        this.accrualPeriod = accrualPeriod;
    }

    public MoneyMarketAccount(double inceptionTime, double accrualPeriod) {
        this(inceptionTime, 1.0, accrualPeriod);
    }

    public MoneyMarketAccount() {
        this(0.0, 1.0, -1.0);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, LIBORModelMonteCarloSimulationInterface model) throws CalculationException {
        if (this.inceptionTime > evaluationTime) {
            return new RandomVariable(0.0);
        }
        if (this.accrualPeriod <= 0.0) {
            return new RandomVariable(Double.MAX_VALUE);
        }
        RandomVariableInterface value = new RandomVariable(this.initialValue);
        for (double time = this.inceptionTime; time < evaluationTime; time += this.accrualPeriod) {
            RandomVariableInterface forwardRate = model.getLIBOR(time, time, time + this.accrualPeriod);
            double currentAccrualPeriod = Math.min(this.accrualPeriod, evaluationTime - time);
            value = value.accrue(forwardRate, currentAccrualPeriod);
        }
        return value;
    }
}

